import { DataTypes } from "sequelize";
import sequelize from "../sequelize/sequelize.js";
import Organization from "../sequelize/OrganizationSchema.js";
import Department from "../sequelize/DepartmentSchema.js";
import User from "../sequelize/UserSchema.js";

export const EndFields = {
  organization: {
    type: DataTypes.INTEGER,
    allowNull: true,
    references: {
      model: Organization,
      key: "id",
    },
  },
  department: {
    type: DataTypes.INTEGER,
    allowNull: true,
    references: {
      model: Department,
      key: "id",
    },
  },
  deleted: {
    type: DataTypes.INTEGER,
    allowNull: true,
    defaultValue: 0,
  },
  created_by: {
    type: DataTypes.INTEGER,
    allowNull: true,
    references: {
      model: "users",
      key: "id",
    },
  },
  updated_by: {
    type: DataTypes.INTEGER,
    allowNull: true,
    references: {
      model: "users",
      key: "id",
    },
  },
  updated_at: {
    type: DataTypes.DATE,
    allowNull: true,
    defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
  },
  created_at: {
    type: DataTypes.DATE,
    allowNull: true,
    defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
  },
};

export const DIR = {
  root: "root",
  ddrm: "ddrm",
};

export const auditLinkedTable = {
  Permits: "permit_license_compliance",
  SOPs: "sops",
  Policy: "policy",
  Action: "custom_action_creation",
  Incident: "incident",
  NCR: "ncr_recording",
  "Business Continuity": "bcp_management",
};
