import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";
import ActionComments from "../sequelize/ActionCommentSchema.js";

export const createUpdateActionComments = async (req, res) => {
  const { id, custom_action_id } = req.body;

  let status = id ? "Updated" : "Created";

  const user = req.user.sessionid;

  req.body[id ? "updated_by" : "created_by"] = user;

  const [check] = await db.query(
    `SELECT * FROM custom_action_creation WHERE id = ${custom_action_id} AND (JSON_CONTAINS(collaborators , CAST(? AS JSON)) OR responsible_person = ?)`,
    [user, user]
  );
  const [orgFetch] = await db.query(
    `SELEcT * FROM custom_action_creation WHERE id = ${custom_action_id}`
  );
  // console.log(check);
  req.body.organization = orgFetch[0]?.organization;
  req.body.department = orgFetch[0]?.department;

  if (check.length > 0 || user == 1) {
    req.body = await encodeAndStringifyFields(req.body);
    const { query, values } = id
      ? updateQueryBuilder(ActionComments, req.body)
      : createQueryBuilder(ActionComments, req.body);
    await db.query(query, values);
    
    await insertActivityLog(req.user.sessionid, status, "Action Comments", id);
    return sendResponse(res, 200, `Record ${status} Successfully`);
  } else {
    return sendResponse(
      res,
      404,
      `You are not authorized to access this record`
    );
  }
};

export const getComments = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "action_comments",
    id,
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    user: req.user,
  });

  const searchTableName = [
    "action_comments.comment",
    "CONCAT(users.name . ' ' , users.surname)",
    "organization.name",
    "department.name",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = action_comments.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = action_comments.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = action_comments.department",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const commentsQuery = `SELECT action_comments.*,CONCAT(users.name , ' ' , users.surname) AS created_by_name , users.profile AS created_by_profile FROM action_comments ${joinCondition} WHERE action_comments.deleted = 0 ${searchCondition} ${condition}`;

  let [comments] = await db.query(commentsQuery);
  comments = await decodeAndParseFields(comments);
  const total = await countQueryCondition(commentsQuery);
  return sendResponse(res, 200, comments, total);
};

export const deleteComments = async (req, res) => {
  const { id } = req.params;
  await deleteRecord(ActionComments, id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "Action Comments",
    `This user deleted a Action Comments Record with id ${id}`
  );
  return sendResponse(res, 200, "Record Deleted Successfully");
};
