import db from "../db-config.js";

import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  decodeSingle_statement,
  deleteRecord,
  encodeAndStringifyFields,
  getOrganizationAccordingToDepartment,
  getRecord,
  insertActivityLog,
  makeJoins,
  processesSingleDDRMDocument,
  processUploadDocuments,
  searchConditionRecord,
  storeError,
  uniqueIdGenerator,
  updateQueryBuilder,
  uploadFile,
  whereCondition,
} from "../helper/general.js";

import { sendResponse } from "../helper/wrapper.js";
import ContractorAgreements from "../sequelize/ContractorAgreementsSchema.js";
import sendEmail from "../helper/sendEmail.js";
import AgreementResponse from "../sequelize/agreementResponseSchema.js";
import AgreementResponseDocs from "../sequelize/agreementResponseDocsSchema.js";

export const createUpdateContractorAgreements = async (req, res) => {
  const { id, contractors } = req.body;

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  console.log(req.body);
  if (contractors && Array.isArray(contractors)) {
    for (const contractor of contractors) {
      const [check] = await db.query(
        `SELECT * FROM contractor_agreements WHERE contractor = ${contractor} AND deleted = 0`
      );
      if (check.length > 0) {
        continue;
      }
      const [fetchOrg] = await db.query(
        `SELECT * FROM contractor_registration WHERE id = ${contractors[0]}`
      );
      req.body.organization = fetchOrg[0]?.organization;
      req.body.department = fetchOrg[0]?.department;
      req.body.contractor = contractor;
      req.body.status = "Not Sent";

      if(!id){
        const unique_id = await uniqueIdGenerator(
          req.body.organization,
          req.body.department ,
          "ContractorAgreements",
          "contractor_agreements",
          "unique_id",
          "unique_id"
        );
        req.body.unique_id = unique_id;
      }

      const { query, values } = id
        ? updateQueryBuilder(ContractorAgreements, req.body)
        : createQueryBuilder(ContractorAgreements, req.body);

      const [result] = await db.query(query, values);

      req.body.public_url = `contractor-agreements/fill/${
        id ? id : result.insertId
      }`;
      await db.query(
        `UPDATE contractor_agreements SET public_url = '${
          req.body.public_url
        }' WHERE id = ${id ? id : result.insertId}`
      );
      await insertActivityLog(
        req.user.sessionid,
        status,
        "Contractor Agreements",
        id ? id : result.insertId
      );
      // send email
    }
  }

  return sendResponse(res, 200, `Record ${status} Successfully`);
};

export const getContractorAgreements = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "contractor_agreements",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = [
    "contractor_registration.contractor_name",
    "CONCAT(users.name , ' ' , users.surname)",
    "organization.name",
    "department.name",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = contractor_agreements.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = contractor_agreements.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = contractor_agreements.department",
    },
    {
      type: "left",
      targetTable: "contractor_registration",
      onCondition:
        "contractor_registration.id = contractor_agreements.contractor",
    },
    {
      type: "left",
      targetTable: "project_registration",
      onCondition: "project_registration.id = contractor_agreements.project",
    },
    {
      type: "left",
      targetTable: "repository",
      onCondition: "repository.id = contractor_agreements.ddrm_id",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const contractorAgreementsQuery = `SELECT contractor_agreements.* , CONCAT(users.name , ' ' , users.surname) AS created_by_name , contractor_registration.contractor_name AS contractor_name, contractor_registration.cipc_registration_number AS contractor_cipc_registration_number ,project_registration.project_title AS project_name , organization.name AS organization_name , department.name AS department_name , repository.url AS document  FROM contractor_agreements ${joinCondition} WHERE contractor_agreements.deleted = 0 ${searchCondition} ${condition}`;

  let [contractorAgreements] = await db.query(contractorAgreementsQuery);

  contractorAgreements = await decodeAndParseFields(contractorAgreements);

  
  

  for (const record of contractorAgreements) {
    let [responses] = await db.query(
      `SELECT agreement_response.*, project_registration.project_title as project_name FROM agreement_response LEFT JOIN project_registration ON agreement_response.project = project_registration.id WHERE agreement_response.contractor_agreement_id = ${record.id} AND agreement_response.deleted = 0`
    );
    responses = await decodeAndParseFields(responses);
    // for (const response of responses) {
    //   const [docs] = await db.query(
    //     `SELECT * FROM agreement_response_docs WHERE agreement_response_id = ${response.id} AND deleted = 0`
    //   );

    //   console.log("response----------",response)
    //   console.log("id",response.id)
    //   console.log("docs",docs)

    //   const [form_template] = response?.contractor_ques_form
    //     ? await db.query(
    //         `SELECT * FROM contractor_forms WHERE id = ${response.contractor_ques_form}`
    //       )
    //     : null;

    //   form_template.forEach((ele) => {
    //     ele.form = ele?.form ? JSON.parse(ele.form) : ele.form;
    //   });
    //   response.form_template = form_template[0].form;
    //   response.images = docs;
    // }

    console.log("responses",responses)

    for (const response of responses) {
      response.contractor = record.contractor;
      response.contractor_name = record.contractor_name;
      response.contractor_cipc_registration_number = record.contractor_cipc_registration_number;
      response.organization = record.organization;
      response.organization_name = record.organization_name;
      response.unique_id = record.unique_id;
    }

    // const id = record.id;
    record.response_received = responses;
  }

  const totalRecord = await countQueryCondition(contractorAgreementsQuery);


  return sendResponse(res, 200, contractorAgreements, totalRecord);
};

export const deleteContractorAgreements = async (req, res) => {
  const { id } = req.params;

  await deleteRecord(ContractorAgreements, id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "Contractor Agreements",
    id
  );

  return sendResponse(res, 200, "Record deleted successfully");
};

// export const sendAgreements = async (req, res) => {
//   const { id, url } = req.body;
//   const [dataFetch] = await db.query(
//     `SELECT contractor_agreements.* , cr.contractor_name AS contractor_name , cr.email AS email  FROM contractor_agreements LEFT JOIN contractor_registration  as cr ON cr.id = contractor_agreements.contractor WHERE contractor_agreements.id = ${id}`
//   );

//   const name = dataFetch[0]?.contractor_name;
//   const email = dataFetch[0]?.email;
//   console.log('email: ', email);
//   const link = url;

//   const sendRecordArray = {
//     templateFileUrl: "mail_for_agreements_template.html",
//     link: link,
//     name: name,
//     message:"Agreement Response",
//   };

//   const info = await sendEmail(
//     "info@harmonyandhelp.com",
//     email,
//     "Agreement Response",
//     sendRecordArray
//   );

//   if (info) {
//     await db.query(
//       `UPDATE contractor_agreements SET status = 'Response Pending' WHERE id = ${id}`
//     );
//     return sendResponse(res, 200, "Agreement sent to email successfully");
//   } else
//     return sendResponse(res, 400, "Agreement sending failed. Please try again");
// };

export const sendAgreements = async (req, res) => {
  const { id, url, name, project } = req.body;
  console.log("body",req.body)
  const total = name.length;
  for (const i of name) {
    i.project = project;

    console.log("project is",project)

    console.log({
      ...i,
      contractor_agreement_id: id,
    })

    const { query, values } = createQueryBuilder(AgreementResponse, {
      ...i,
      contractor_agreement_id: id,
    });
    const [result] = await db.query(query, values);
    const link = url + "/" + result.insertId;

    const sendRecordArray = {
      templateFileUrl: "mail_for_agreements_template.html",
      link: link,
      name: i.title,
      message: "Agreement Response",
      templateName: "Agreements",
    };

    const info = await sendEmail(
      "info@harmonyandhelp.com",
      i.employee_email,
      "Agreement Response",
      sendRecordArray
    );

    if (info) {
      await db.query(
        `UPDATE contractor_agreements SET status = 'Response Pending' , total = ${total} , responses = 0 WHERE id = ${id}`
      );
    } else
      return sendResponse(
        res,
        400,
        "Agreement sending failed. Please try again"
      );
  }
  return sendResponse(res, 200, "Agreement sent to email successfully");
};

export const fillForm = async (req, res) => {
  const { id, sidebar_id = 259 , fromEmail = false } = req.body;

  req.body.from_email = fromEmail === true  ? 1 : 0

  console.log("req.body",req.body)

  const [dataFetch] = await db.query(
    `SELECT * FROM agreement_response WHERE id = ${id}`
  );

  console.log("dataFetch",dataFetch)

  if(dataFetch.length === 0){
    return sendResponse(
      res,
      400,
      "Agreement does not exist with this id"
    );
  }

  let form = req.body;
  delete req.body.contractor;
  delete req.body.project;
  if (dataFetch[0]?.status === "Response Received") {
    return sendResponse(res, 400, "Response already submitted");
  }

  console.log(dataFetch[0])

  // console.log(req.files);

  // let document = [];

  // for (let i = 0; i <= 10; i++) {
  //   if (
  //     (req?.files && req.files[`document[${i}]`]) ||
  //     req.body[`document[${i}]`]
  //   ) {
  //     const file = req.files[`document[${i}]`];
  //     if (typeof file != "string" && typeof file == "object") {
  //       const filePath = await uploadFile("contractor_questionnaire", file);
  //       document.push({ file: filePath, doc_no: i });
  //     } else {
  //       document.push({ file: req.body[`document[${i}]`], doc_no: i });
  //     }
  //   }
  // }
  let document = await processUploadDocuments(req, sidebar_id, "document");

  await deleteRecord(AgreementResponseDocs, id, "agreement_response_id");

  req.body.images = document;

  req.body = await encodeAndStringifyFields(req.body);
  form.status = "Response Received";
  const { query, values } = updateQueryBuilder(AgreementResponse, form);
  console.log(query, values )
  const [result] = await db.query(query, values);

  for (let i = 0; i < document.length; i++) {
    let doc = document[i];
    const { query, values } = createQueryBuilder(AgreementResponseDocs, {
      ...doc,
      agreement_response_id: id ? id : result.insertId,
    });
    await db.query(query, values);
  }

  if (result.affectedRows > 0) {
    // also update status to Response Received if number of response equal to total response
    const [contractorAgreements] = await db.query(
      `SELECT * FROM contractor_agreements WHERE id = ${dataFetch[0].contractor_agreement_id}`
    );
    let status = "";
    if (
      contractorAgreements[0].total ===
      contractorAgreements[0].responses + 1
    ) {
      status = `, status = 'Response Received'`;
    }
    await db.query(
      `UPDATE contractor_agreements SET responses = responses + 1 ${status}  WHERE id = ${dataFetch[0].contractor_agreement_id}`
    );
    return sendResponse(res, 200,  "Form Filled successfully");
  }
  return sendResponse(res, 400, "Record Not updated");
};

export const enableDisableForm = async (req, res) => {
  const { id, status } = req.body;
  const [update] = await db.query(
    `UPDATE contractor_agreements SET status = ?  WHERE id = ?`,
    [status, id]
  );
  if (update.affectedRows > 0) {
    return sendResponse(res, 200, "Status updated successfully");
  } else {
    return sendResponse(
      res,
      400,
      "Some error occurred while updating the status "
    );
  }
};
