import asyncHandler from "express-async-handler";
import db from "../db-config.js";
import {
  inWhereFormat,
  insertActivityLog,
  isTeamLeader,
  storeError,
} from "../helper/general.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to view all contractor meeting recording approval */
export const viewAllContractorMeetingApproval = asyncHandler(async (req, res) => {
  try {
    const { id } = req.params;
    const { business, scheduled_meeting } = req.query;

    let where = id ? `AND contractor_meeting_recording.id = ${id}` : "";

    let extraFilter = business
      ? scheduled_meeting
        ? `AND contractor_meeting_recording.organization = ${business} 
           AND contractor_meeting_recording.scheduled_meeting = ${scheduled_meeting}`
        : `AND contractor_meeting_recording.organization = ${business}`
      : ``;

    /** If searching for status based filter then also filter on the basis of scriber based filter */

    let status = req.query.status
      ? `AND contractor_meeting_recording.status = '${req.query.status}' AND contractor_meeting_recording.meeting_scriber = ${req.user.sessionid}`
      : `AND contractor_meeting_recording.meeting_scriber = ${req.user.sessionid} AND contractor_meeting_recording.status !=0`;

    const page = parseInt(req.query.page) || 1;

    const pageSize = parseInt(req.query.pageSize) || 10;

    const offset = (page - 1) * pageSize;

    const all = req.query.all;

    const searchWord = req.query.search || "";

    /** filter on the basis of leader or not */

    const leaderFilter = await isTeamLeader(
      req.user.sessionid,
      "contractor_meeting_recording",
      "contractor_meeting_recording"
    );

    /**Check multiple users organization */
    const organization = await inWhereFormat(req.additionalData);
    // return console.log(organization)
    /**Check if login person is super admin of that organization then show all record */
    const isSuperAdmin =
      req.user.sessionidRole == 0
        ? `AND contractor_meeting_recording.organization in ${organization}`
        : `AND contractor_meeting_recording.organization in ${organization}`;

    /** If value come with any search condition then search that word */

    // Issue with the contractor_meeting id search
    let searchCondition = searchWord
      ? `AND (contractor_meeting_recording.meeting_title LIKE '%${searchWord}%' OR contractor_meeting_recording.status LIKE '%${req.query.search}%' OR contractor_meeting.meeting_id LIKE '%${req.query.search}%' OR contractor_meeting.venue LIKE '%${searchWord}%' OR organization.name LIKE '%${searchWord}%' OR u1.name LIKE '%${searchWord}%' OR u2.name LIKE '%${searchWord}%' OR users.name LIKE '%${req.query.search}%')`
      : "";

    /** If query come with pagination then pagination come otherwise show all data*/
    let pagination =
      all === "false" ? `LIMIT ${pageSize} OFFSET ${offset}` : ``;

    /**Record of all contractor_meeting */

    let meetingQuery = `SELECT 
    contractor_meeting_recording.*, 
    contractor_meeting_recording.created_by as created_by_id, 
    contractor_meeting_recording.id, 
    contractor_meeting_recording.planned_meeting_date_from, 
    contractor_meeting_recording.planned_meeting_date_to,
    contractor_meeting_recording.organization,
    contractor_meeting_recording.scheduled_meeting,
    contractor_meeting_recording.status,
    contractor_meeting.meeting_title,
    contractor_meeting_recording.meeting_title, 
    u1.name as meeting_scriber_name, 
    u2.name as meeting_chairperson_name,
    users.name as created_by, 
    organization.name as organization_name,
    contractor_meeting.meetingHost,
    contractor_meeting.meetingId,
    contractor_meeting.location,
    contractor_meeting.meetingType,
    hierarchy.name as name,
    u3.name as meeting_owner_name
FROM 
    contractor_meeting_recording 
LEFT JOIN 
    contractor_meeting ON contractor_meeting.id = contractor_meeting_recording.scheduled_meeting 
LEFT JOIN 
    hierarchy ON hierarchy.id = contractor_meeting.meetingType
LEFT JOIN 
    users ON users.id = contractor_meeting_recording.created_by
LEFT JOIN 
    users AS u1 ON u1.id = contractor_meeting_recording.meeting_scriber
LEFT JOIN 
    users AS u2 ON u2.id = contractor_meeting_recording.meeting_chairperson
LEFT JOIN 
    organization ON organization.id = contractor_meeting_recording.organization 
LEFT JOIN 
    users AS u3 ON contractor_meeting.meetingHost = u3.id
WHERE 
    contractor_meeting_recording.deleted = 0
    ${where} 
    ${isSuperAdmin} 
    ${searchCondition} 
    ${extraFilter}
    ${leaderFilter}
    ${status}
ORDER BY 
    contractor_meeting_recording.id DESC 
    ${pagination}
`;

    // return console.log(meetingQuery)
    const meetingRecordings = await db.query(meetingQuery);
    // return console.log(meetingQuery)
    meetingRecordings.forEach((meet) => {
      meet.participants = [...JSON.parse(meet.participants || "[]")].map(
        (e) => {
          return {
            ...e,
            meetingId: meet.meetingId,
          };
        }
      );
      meet.meeting_notes = [...JSON.parse(meet.meeting_notes || "[]")].map(
        (e) => {
          return {
            ...e,
            meetingId: meet.meetingId,
          };
        }
      );
    });
    const countDataFetch = await db.query(
      `SELECT count(id) as meeting_record_id FROM contractor_meeting_recording WHERE deleted = 0 ${isSuperAdmin} ${searchCondition} ${leaderFilter}
      ${extraFilter} ${status}`
    );
    return res.status(200).json({
      status: true,
      data: meetingRecordings,
      total: countDataFetch[0].meeting_record_id,
    });
  } catch (error) {
    /** Check if error is come then send that error to log file  */
    storeError(error);
    res.status(500).json({
      status: false,
      message: error.message,
    });
  }
});

/**Function to specific contractor_meeting recording or approval by id */
export const viewAllContractorMeetingApprovalById = asyncHandler(async (req, res) => {
  try {
    const { meetingId } = req.params;

    let where = meetingId ? `AND contractor_meeting.meetingId = '${meetingId}'` : "";

    /**Check multiple users organization */
    const organization = await inWhereFormat(req.additionalData);
    // return console.log(organization)
    /**Check if login person is super admin of that organization then show all record */
    let isSuperAdmin =
      req.user.sessionidRole == 0
        ? `AND contractor_meeting_recording.organization in ${organization}`
        : `AND contractor_meeting_recording.organization in ${organization}`;

    /**Record of all contractor_meeting */

    let meetingQuery = `SELECT 
    contractor_meeting_recording.*,
    contractor_meeting.meetingId,
    contractor_meeting_recording.created_by as created_by_id, 
    contractor_meeting_recording.id, 
    contractor_meeting_recording.planned_meeting_date_from, 
    contractor_meeting_recording.planned_meeting_date_to, 
    contractor_meeting_recording.organization, 
    contractor_meeting_recording.scheduled_meeting, 
    contractor_meeting_recording.status,
    contractor_meeting.meeting_title, 
    contractor_meeting.agenda,
    contractor_meeting_recording.meeting_title, 
    u1.name as meeting_scriber_name, 
    u2.name as meeting_chairperson_name, 
    users.name as created_by, 
    organization.name as organization_name, 
    contractor_meeting.meetingHost, 
    contractor_meeting.location, 
    contractor_meeting.meetingType, 
    hierarchy.name as name, 
    u3.name as meeting_owner_name 
FROM 
    contractor_meeting_recording 
LEFT JOIN 
    contractor_meeting ON contractor_meeting.id = contractor_meeting_recording.scheduled_meeting 
LEFT JOIN 
    hierarchy ON hierarchy.id = contractor_meeting.meetingType 
LEFT JOIN 
    users ON users.id = contractor_meeting_recording.created_by 
LEFT JOIN 
    users AS u1 ON u1.id = contractor_meeting_recording.meeting_scriber 
LEFT JOIN 
    users AS u2 ON u2.id = contractor_meeting_recording.meeting_chairperson 
LEFT JOIN 
    organization ON organization.id = contractor_meeting_recording.organization 
LEFT JOIN 
    users AS u3 ON contractor_meeting.meetingHost = u3.id 
WHERE 
    contractor_meeting_recording.deleted = 0 
    ${where} 
    ${isSuperAdmin}
`;

    const meetingRecordings = await db.query(meetingQuery);

    if (meetingRecordings.length == 0) {
      /** check record of contractor_meeting  */
      where = meetingId ? `AND contractor_meeting.meetingId = '${meetingId}'` : "";
      isSuperAdmin =
        req.user.sessionidRole == 0
          ? `AND contractor_meeting.organization in ${organization}`
          : `AND contractor_meeting.organization in ${organization}`;
      const meetQuery = `SELECT contractor_meeting.*, contractor_meeting.meetingId, contractor_meeting.meetingHost as meeting_owner_id, u1.name as meeting_owner_name, u1.profile as meeting_owner_profile, contractor_meeting.created_by as created_by_id,contractor_meeting.meetingType as meeting_hierarchy_id, hierarchy.name,hierarchy.description,contractor_meeting.organization,users.name as created_by, organization.name as organization_name from 
        contractor_meeting left join hierarchy on hierarchy.id = contractor_meeting.meetingType
        left join users on users.id = contractor_meeting.created_by
        left join users as u1 on u1.id = contractor_meeting.meetingHost
        left join organization on organization.id = contractor_meeting.organization 
        where contractor_meeting.deleted = 0 ${where} 
        ${isSuperAdmin}`;
      const contractor_meeting = await db.query(meetQuery);
      const meetingArray = [];
      const insertPromise = contractor_meeting.map(async (meet) => {
        const participants = meet.participants
          ? JSON.parse(meet.participants || "[]")
          : [];
        let user = [];
        if (participants.length) {
          user = await db.query(
            `SELECT name ,id from users where id In (${participants})`
          );
        }
        meet.participants = user;
        meet.agenda = JSON.parse(meet.agenda || "[]");

        /** check the assigned person of agenda  */
        for (let agenda of meet.agenda) {
          if (agenda.allocated_to) {
            let allocated_person_name = await db.query(
              `SELECT name from users where id = ${agenda.allocated_to}`
            );
            agenda.allocated_person_name = allocated_person_name[0]?.name;
          }
        }
        meetingArray.push(meet);
      });
      await Promise.all(insertPromise);

      return res.status(200).json({
        status: true,
        data: contractor_meeting,
      });
    }

    const insertPromise = meetingRecordings.map(async (meet) => {
      meet.participants = JSON.parse(meet.participants || "[]");
      meet.meeting_notes = JSON.parse(meet.meeting_notes);
      meet.agenda = JSON.parse(meet.agenda || "[]");
      /** check the assigned person of agenda  */
      for (let agenda of meet.agenda) {
        if (agenda.allocated_to) {
          let allocated_person_name = await db.query(
            `SELECT name from users where id = ${agenda.allocated_to}`
          );
          agenda.allocated_person_name = allocated_person_name[0]?.name;
        }
      }
      /** check the assigned person of agenda */
      for (let notes of meet.meeting_notes) {
        if (notes.allocated_to) {
          const allocated_person_name = await db.query(
            `SELECT name from users where id = ${notes.allocated_to}`
          );
          notes.allocated_person_name = allocated_person_name[0]?.name;
          notes.title = meet?.agenda.filter(
            (e) => e.id == notes.value
          )[0]?.title;
          notes.canAddComment = notes.allocated_to === req.user.sessionid;
        }
      }
    });

    await Promise.all(insertPromise);

    return res.status(200).json({
      status: true,
      data: meetingRecordings,
    });
  } catch (error) {
    /** Check if error is come then send that error to log file  */
    storeError(error);
    res.status(500).json({
      status: false,
      message: error.message,
    });
  }
});

/**Function to add comment to a specific Meeting Recording approval by scriber */
export const addCommentToContractorMeetingApproval = async (req, res) => {
  const { comment, id, approval_status } = req.body;
  let status = approval_status;
  let where = req.user.isSuperAdmin
    ? ""
    : `AND meeting_scriber = ${req.user.sessionid} `;
  const query = `UPDATE contractor_meeting_recording SET status = ?, comment = ? WHERE id = ?  ${where}`;
  const [addComment] = await db.query(query, [status, comment ?? "", id]);
  if (addComment.affectedRows === 0) {
    return sendResponse(res, 404, "You haven't access to approve this contractor_meeting");
  } else {
    /**Insert record for activity log */
    insertActivityLog(
      req.user.sessionid,
      "add",
      "Comment",
      `This user add comment and status for contractor_meeting which id is ${id} and status is ${status}`
    );
    return sendResponse(res, 200, `Record ${status} successfully`);
  }
};
