import db from "../db-config.js";

import {
  countQueryCondition,
  createQueryBuilder,
  decodeAndParseFields,
  deleteRecord,
  encodeAndStringifyFields,
  insertActivityLog,
  makeJoins,
  processUploadDocuments,
  searchConditionRecord,
  uniqueIdGenerator,
  updateQueryBuilder,
  uploadFile,
  whereCondition,
} from "../helper/general.js";

import { sendResponse } from "../helper/wrapper.js";
import ContractorQuestionnaire from "../sequelize/ContractorQuestionnaireSchema.js";
import sendEmail from "../helper/sendEmail.js";
import ContractorQuestionnaireDocs from "../sequelize/ContractorQuestionnaireDocsSchema.js";
import QuestionnaireResponses from "../sequelize/QuestionnaireResponsesSchema.js";

export const createUpdateContractorQuestionnaire = async (req, res) => {
  const { id, contractors } = req.body;

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  if (contractors && Array.isArray(contractors)) {
    for (const contractor of contractors) {
      const [check] = await db.query(
        `SELECT * FROM contractor_questionnaire WHERE contractor = ${contractor} AND deleted = 0`
      );
      if (check.length > 0) {
        continue;
      }
      const [fetchOrg] = await db.query(
        `SELECT * FROM contractor_registration WHERE id = ${contractors[0]}`
      );
      req.body.organization = fetchOrg[0]?.organization;
      req.body.department = fetchOrg[0]?.department;
      req.body.contractor = contractor;
      req.body.status = "Not Sent";
      req.body = await encodeAndStringifyFields(req.body);

      if (!id) {
        const unique_id = await uniqueIdGenerator(
          req.body.organization,
          req.body.department,
          "ContractorQuestionnaire",
          "contractor_questionnaire",
          "unique_id",
          "unique_id"
        );
        req.body.unique_id = unique_id;
      }

      const { query, values } = id
        ? updateQueryBuilder(ContractorQuestionnaire, req.body)
        : createQueryBuilder(ContractorQuestionnaire, req.body);
      const [result] = await db.query(query, values);

      req.body.public_url = `contractor-questionnaire/fill/${
        id ? id : result.insertId
      }`;
      await db.query(
        `UPDATE contractor_questionnaire SET public_url = '${
          req.body.public_url
        }' WHERE id = ${id ? id : result.insertId}`
      );

      await insertActivityLog(
        req.user.sessionid,
        status,
        "Contractor Questionnaire",
        id ? id : result.insertId
      );
      // send email
    }
  }

  return sendResponse(res, 200, `Record ${status} Successfully`);
};

export const getContractorQuestionnaire = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "contractor_questionnaire",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = [
    "contractor_registration.contractor_name",
    "CONCAT(users.name , ' ' , users.surname)",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = contractor_questionnaire.created_by",
    },
    {
      type: "left",
      targetTable: "contractor_registration",
      onCondition:
        "contractor_registration.id = contractor_questionnaire.contractor",
    },
    {
      type: "left",
      targetTable: "project_registration",
      onCondition: "project_registration.id = contractor_questionnaire.project",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = contractor_questionnaire.organization",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const contractorQuestionnaireQuery = `SELECT contractor_questionnaire.* , CONCAT(users.name , ' ' , users.surname) AS created_by_name , contractor_registration.contractor_name AS contractor_name , organization.name AS organization_name , contractor_registration.cipc_registration_number AS contractor_cipc_registration_number , project_registration.project_title AS project_name  FROM contractor_questionnaire ${joinCondition} WHERE contractor_questionnaire.deleted = 0 ${searchCondition} ${condition}`;

  let [contractorQuestionnaire] = await db.query(contractorQuestionnaireQuery);

  contractorQuestionnaire = await decodeAndParseFields(contractorQuestionnaire);

  for (const record of contractorQuestionnaire) {
    let [responses] = await db.query(
      `SELECT * FROM questionnaire_response WHERE contractor_questionnaire_id = ${record.id} AND deleted = 0`
    );
    responses = await decodeAndParseFields(responses);

    for (const response of responses) {
      const [docs] = await db.query(
        `SELECT * FROM contractor_questionnaire_docs WHERE questionnaire_response_id = ${response.id} AND deleted = 0`
      );
      const [form_template] = response?.contractor_ques_form
        ? await db.query(
            `SELECT * FROM contractor_forms WHERE id = ${response.contractor_ques_form}`
          )
        : [[]];

      form_template?.forEach((ele) => {
        ele.form = ele?.form ? JSON.parse(ele.form) : ele.form;
      });
      response.unique_id - record?.unique_id;
      response.form_template = form_template[0]?.form;
      response.images = docs;
      response.contractor = record.contractor;
      response.contractor_name = record.contractor_name;
      response.contractor_cipc_registration_number =
        record.contractor_cipc_registration_number;
      response.organization = record.organization;
      response.unique_id = record.unique_id;
    }
    // const id = record.id;
    record.response_received = responses;
  }

  const totalRecord = await countQueryCondition(contractorQuestionnaireQuery);

  return sendResponse(res, 200, contractorQuestionnaire, totalRecord);
};

export const deleteContractorQuestionnaire = async (req, res) => {
  const { id } = req.params;

  await deleteRecord(ContractorQuestionnaire, id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "Contractor Questionnaire",
    id
  );

  return sendResponse(res, 200, "Record deleted successfully");
};

export const sendQuestionnaire = async (req, res) => {
  const { id, url, name, contractor_ques_form, project } = req.body;
  const total = name.length;
  for (const i of name) {
    i.contractor_ques_form = contractor_ques_form;
    i.project = project;
    const { query, values } = createQueryBuilder(QuestionnaireResponses, {
      ...i,
      contractor_questionnaire_id: id,
    });
    const [result] = await db.query(query, values);
    const link = url + "/" + result.insertId;

    const sendRecordArray = {
      templateFileUrl: "mail_for_questionnaire_template.html",
      link: link,
      name: i.title,
      templateName: "Questionnaire",
    };

    const info = await sendEmail(
      "info@harmonyandhelp.com",
      i.employee_email,
      "Questionnaire Response",
      sendRecordArray
    );

    if (info) {
      await db.query(
        `UPDATE contractor_questionnaire SET status = 'Response Pending' , total = ${total} , responses = 0 WHERE id = ${id}`
      );
    } else
      return sendResponse(
        res,
        400,
        "Questionnaire sending failed. Please try again"
      );
  }
  return sendResponse(res, 200, "Questionnaire sent to email successfully");
};

// id, organization, contractor, cipc, project, contractor_ques_form;

export const fillForm = async (req, res) => {
  req.body = (await decodeAndParseFields([req.body]))[0];
  const { id, sidebar_id = 259 } = req.body;
  const [dataFetch] = await db.query(
    `SELECT * FROM questionnaire_response WHERE id = ${id}`
  );
  let form = req.body;
  delete req.body.contractor;
  delete req.body.project;
  if (dataFetch[0]?.status === "Response Received") {
    return sendResponse(res, 400, "Response already submitted");
  }

  // let document = [];

  // for (let i = 0; i <= 10; i++) {
  //   if (
  //     (req?.files && req.files[`document[${i}]`]) ||
  //     req.body[`document[${i}]`]
  //   ) {
  //     const file = req.files[`document[${i}]`];
  //     if (typeof file != "string" && typeof file == "object") {
  //       const filePath = await uploadFile("contractor_questionnaire", file);
  //       document.push({ file: filePath, doc_no: i });
  //     } else {
  //       document.push({ file: req.body[`document[${i}]`], doc_no: i });
  //     }
  //   }
  // }

  let document = await processUploadDocuments(req, sidebar_id, "document");

  await deleteRecord(
    ContractorQuestionnaireDocs,
    id,
    "questionnaire_response_id"
  );

  req.body.images = document;

  req.body = await encodeAndStringifyFields(req.body);
  form.status = "Response Received";
  const { query, values } = updateQueryBuilder(QuestionnaireResponses, form);
  const [result] = await db.query(query, values);

  for (let i = 0; i < document.length; i++) {
    let doc = document[i];
    const { query, values } = createQueryBuilder(ContractorQuestionnaireDocs, {
      ...doc,
      doc_no: i,
      questionnaire_response_id: id ? id : result.insertId,
    });
    await db.query(query, values);
  }

  if (result.affectedRows > 0) {
    // also update status to Response Received if number of response equal to total response
    const [contractorQuestionnaire] = await db.query(
      `SELECT * FROM contractor_questionnaire WHERE id = ${dataFetch[0].contractor_questionnaire_id}`
    );
    let status = "";
    if (
      contractorQuestionnaire[0].total ===
      contractorQuestionnaire[0].responses + 1
    ) {
      status = `, status = 'Response Received'`;
    }
    await db.query(
      `UPDATE contractor_questionnaire SET responses = responses + 1 ${status}  WHERE id = ${dataFetch[0].contractor_questionnaire_id}`
    );
    return sendResponse(res, 200, "Form Filled successfully");
  }
  return sendResponse(res, 400, "Record Not updated");
};

export const enableDisableForm = async (req, res) => {
  const { id, status } = req.body;
  const [update] = await db.query(
    `UPDATE contractor_questionnaire SET status = ?  WHERE id = ?`,
    [status, id]
  );
  if (update.affectedRows > 0) {
    return sendResponse(res, 200, "Status updated successfully");
  }
  return sendResponse(
    res,
    400,
    "Some error occurred while updating the status "
  );
};
