import db from "../db-config.js";
  import { sendResponse } from "../helper/wrapper.js";
  import { 
    insertActivityLog, 
    searchConditionRecord, 
    makeJoins, 
    whereCondition, 
    countQueryCondition, 
    settingsUpdater,
    deleteSettingRecord, 
    encodeSingle_statement, 
    decodeSingle_statement ,
  } from "../helper/general.js";
  import EngagementMethod from "../sequelize/EngagementMethodSchema.js";

  /** Function to create or update EngagementMethod */
  export const createUpdateEngagementMethod = async (req, res) => {
    const { id, name, description } = req.body;
    const encodedDescription = await encodeSingle_statement(description);

    if (id) {
      const result = await settingsUpdater(
        EngagementMethod,
        req.body.organization,
        req.body,
        req.user
      );
      if (!result) {
        return sendResponse(res, 404, "No data found");
      }
      await insertActivityLog(req.user.sessionid, "update", "EngagementMethod", `This user updated EngagementMethod with id: ${id}`);
      return sendResponse(res, 200, "Record updated successfully");
    } else {
      const insertPromises = req.body.organization.map(async (org) => {
        const [checkName] = await db.query(`SELECT name FROM engagement_method WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
        if (checkName.length === 0) {
          await db.query(`INSERT INTO engagement_method (name, description, created_by, organization) VALUES (?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org]);
          await insertActivityLog(req.user.sessionid, "create", "EngagementMethod", `This user created a new EngagementMethod '${name}' for organization ${org}`);
        }
      });
      await Promise.all(insertPromises);
      return sendResponse(res, 200, "Record created successfully");
    }
  };

  /** Function to view all or single EngagementMethod */
  export const viewEngagementMethod = async (req, res) => {
    const { id } = req.params;
    const condition = await whereCondition({
      table: "engagement_method",
      page: req.query.page,
      all: req.query.all,
      pageSize: req.query.pageSize,
      filter: req.query.filter,
      id,
      user: req.user,
      grouped: req.query.grouped,
    });

    const searchFields = [
      "engagement_method.name",
      "engagement_method.description",
      "users.name",
      "organization.name"
    ];
    let searchCondition = await searchConditionRecord(req.query.search, searchFields);
    const joins = [
      { type: "left", targetTable: "users", onCondition: "users.id = engagement_method.created_by" },
      { type: "left", targetTable: "organization", onCondition: "organization.id = engagement_method.organization" }
    ];
    const joinsRecord = await makeJoins(joins);

    const fetchQuery = `SELECT engagement_method.*, users.name AS created_by, organization.name AS organization_name FROM engagement_method ${joinsRecord} WHERE engagement_method.deleted = 0 ${searchCondition} ${condition}`;
    let [records] = await db.query(fetchQuery);

    for (const record of records) {
      record.description = await decodeSingle_statement(record.description);
        if (req.query.grouped == "true") {
        const [organizations] = await db.query(
          `SELECT organization FROM engagement_method WHERE deleted = 0 AND name = ?`,
          [record.name]
        );
        const arr = organizations.map((item) => item.organization);
        record.organizations = arr;
      }
    }

    const totalRecord = await countQueryCondition(fetchQuery);
    return sendResponse(res, 200, records, totalRecord);
  };

  /** Function to delete EngagementMethod */
  export const deleteEngagementMethod = async (req, res) => {
    const { id } = req.params;
    const deleteRecord = await deleteSettingRecord("engagement_method", id);
    if (deleteRecord) {
      await insertActivityLog(req.user.sessionid, "delete", "EngagementMethod", id);
      return sendResponse(res, 200, "Record deleted successfully");
    } else {
      return sendResponse(res, 404, "Record not found");
    }
  };