import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  settingsUpdater,
  uniqueIdGenerator,
  getRecord,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getFilterConditions,
  updateQueryBuilder,
  createQueryBuilder
} from "../helper/general.js";
import FirstAidBoxContent from "../sequelize/FirstAidBoxContentSchema.js";

/** Function to create or update FirstAidBoxContent */
export const createUpdateFirstAidBoxContent = async (req, res) => {
  const { id, name, description,organization, department } = req.body;
  const encodedDescription = await encodeSingle_statement(description);

  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord("first_aid_box_content", "name", name);
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "FirstAidBoxContent name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "FirstAidBoxContent name already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(FirstAidBoxContent, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "FirstAidBoxContent",
      `This user updated FirstAidBoxContent with id: ${id}`
    );    
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const orgData = await getFirstCreatedAndAllOrganizationIds();
    if (!orgData.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    req.body.unique_id = await uniqueIdGenerator(
      orgData.firstOrgId,
      req.body?.department || null,
      "FABC",
      "first_aid_box_content",
      "unique_id",
      "unique_id"
    );
    // req.body.organization = organization.length > 0 ? organization : result.organizationIds;
    const { query, values } = createQueryBuilder(FirstAidBoxContent, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "FirstAidBoxContent",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

};

/** Function to view all or single FirstAidBoxContent */
export const viewFirstAidBoxContent = async (req, res) => {

  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "first_aid_box_content"
  );
 
  const searchFields = [
    "first_aid_box_content.name",
    "first_aid_box_content.description",
    "users.name",
  ];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    { type: "left", targetTable: "users", onCondition: "users.id = first_aid_box_content.created_by" },
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT first_aid_box_content.*, users.name AS created_by, first_aid_box_content.organization AS organizations FROM first_aid_box_content ${joinsRecord} WHERE first_aid_box_content.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);
 

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete FirstAidBoxContent */
export const deleteFirstAidBoxContent = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("first_aid_box_content", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "FirstAidBoxContent", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
