import {
  countQueryCondition,
  decodeSingle_statement,
  deleteRecord,
  encodeSingle_statement,
  getOrganizationAccordingToDepartment,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import db from "../db-config.js";
import { createQueryBuilder } from "../helper/queryBuilder.js";
import { sendResponse } from "../helper/wrapper.js";
import HazmatFireTechnical from "../sequelize/HazmatFireTechnicalFormSchema.js";

/**Function to create Safety Incident Form  */
export const createHazmatFireTechnical = async (req, res) => {
  const { id } = req.body;
  const sessionId = req.user.sessionid;
  let organizationId = req.body.organization;
  const { department, comments, hazmat, fire } = req.body;

  if (department) {
    const recordAccordingToOrganization = await getOrganizationAccordingToDepartment(department);
    organizationId = recordAccordingToOrganization[0]?.organization;
    if (organizationId) {
      req.body.organization = organizationId;
    }
  }

  req.body.hazmat = await encodeSingle_statement(hazmat);
  req.body.fire = await encodeSingle_statement(fire);
  req.body.comments = await encodeSingle_statement(comments);
  req.body.created_by = sessionId;

  const { query, values } = id
    ? updateQueryBuilder(HazmatFireTechnical, req.body)
    : createQueryBuilder(HazmatFireTechnical, req.body);
  const [createHazmatForm] = await db.query(query, values);
  if (!id && createHazmatForm.insertId === 0) {
    return sendResponse(res, 404, "Cannot create record");
  }

  await insertActivityLog(
    req.user.sessionid,
    "create",
    "Safety Incident Form",
    `This user created a new Safety Incident Form Record for organization ${organizationId}`
  );

  return sendResponse(res, 200, "Record created successfully");
};

export const getHazmatFireTechnical = async (req, res) => {
  // involved_employee_details_name;
  // tested_by_who;
  // reported_by_who;

  const { type } = req.query;
  const { id } = req.params;
  const condition = await whereCondition({
    table: "hazmat_fire_technical_form",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
    columnName: type,
  });
  const searchTableName = [
    "hazmat_fire_technical_form.occupational_disease_details",
    "hazmat_fire_technical_form.type_of_occurrence",
    "hazmat_fire_technical_form.location_of_occurrence",
    "hazmat_fire_technical_form.occurrence_ref_no",
    "hazmat_fire_technical_form.immediate_cause_of_occurrence",
    "hazmat_fire_technical_form.involved_employee_details_name",
    "hazmat_fire_technical_form.involved_employee_details_employee_sap",
    "hazmat_fire_technical_form.involved_employee_details_employee_type",
    "hazmat_fire_technical_form.involved_employee_details_experience",
    "hazmat_fire_technical_form.involved_employee_details_role",
    "hazmat_fire_technical_form.was_alcohol_or_substance_testing_done",
    "hazmat_fire_technical_form.select_substance_testing",
    "hazmat_fire_technical_form.tested_by_who",
    "hazmat_fire_technical_form.substance_test_results",
    "hazmat_fire_technical_form.method_of_testing",
    "hazmat_fire_technical_form.was_person_or_operator_licensed_trained",
    "hazmat_fire_technical_form.was_license_training_applicable_to_task",
    "hazmat_fire_technical_form.license_no_training_certificate_no",
    "hazmat_fire_technical_form.issued_by",
    "hazmat_fire_technical_form.occurrence_level",
    "hazmat_fire_technical_form.was_case_reported_to_authority_regulator",
    "hazmat_fire_technical_form.name_of_authority",
    "hazmat_fire_technical_form.reported_by_who",
    "hazmat_fire_technical_form.comments",
    "hazmat_fire_technical_form.form_completed_by",
    "hazmat_fire_technical_form.designation",
    "hazmat_fire_technical_form.signature",
    "organization.name",
    "department.name",
    "CONCAT(users.name , ' ' , users.surname)",
  ];

  const searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = hazmat_fire_technical_form.created_by",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "organization.id = hazmat_fire_technical_form.organization",
    },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = hazmat_fire_technical_form.department",
    },
    {
      type: "left",
      targetTable: "users AS involved",
      onCondition: "involved.id = hazmat_fire_technical_form.involved_employee_details_name",
    },
    {
      type: "left",
      targetTable: "roles",
      onCondition: "roles.id = involved.role",
    },
  ];
  const joinCondition = await makeJoins(joins);

  const hazmatFireTechnicalQuery = `SELECT hazmat_fire_technical_form.* , organization.name as organization_name ,department.name as department_name , users.name as created_by_name , users.surname as created_by_surname  , users.profile as created_by_profile , CONCAT(involved.name , ' ' , involved.surname) AS involved_employee_details_name_name , involved.profile AS involved_employee_details_name_profile ,involved.unique_id AS involved_employee_details_employee_number , involved.employee_type AS involved_employee_details_employee_type , roles.name AS involved_employee_details_role , roles.year_of_experience AS involved_employee_details_experience  FROM hazmat_fire_technical_form ${joinCondition} WHERE hazmat_fire_technical_form.deleted = 0 ${condition} ${searchCondition}`;
  const totalRecord = await countQueryCondition(hazmatFireTechnicalQuery);

  const [hazmatFireTechnical] = await db.query(hazmatFireTechnicalQuery);

  for (const data of hazmatFireTechnical) {
    data.comments = await decodeSingle_statement(data.comments);
    data.hazmat = await decodeSingle_statement(data.hazmat);
    data.fire = await decodeSingle_statement(data.fire);
    if (data.tested_by_who == 1) {
      console.log(data.tested_by_employee);
      if (data.tested_by_employee) {
        const [fetchUser] = await db.query(
          `SELECT CONCAT(name , ' '  , surname) AS name , profile FROM users WHERE id = ${Number(
            data.tested_by_employee
          )}`
        );
        data.tested_by_employee_name = fetchUser[0]?.name;
        data.tested_by_employee_profile = fetchUser[0]?.profile;
      }
    }
  }
  return sendResponse(res, 200, hazmatFireTechnical, totalRecord);
};

export const deleteHazmatFireTechnical = async (req, res) => {
  const { id } = req.params;
  const deleteForm = await deleteRecord("hazmat_fire_technical_form", id);
  if (deleteForm) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Injury On Duty Form",
      `This user deleted a new Injury On duty Form Record for organization ${id}`
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
  return sendResponse(res, 404, "Cannot delete record");
};
