import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  getRecord,
  getListingData,
  getFilterConditions,
} from "../helper/general.js";
import IncidentPpe from "../sequelize/IncidentPpeSchema.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/** Function to create or update IncidentPpe */
// export const createUpdateIncidentPpe = async (req, res) => {
//   const { id, name, description } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       IncidentPpe,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "IncidentPpe", `This user updated IncidentPpe with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM incident_ppe WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//         await db.query(`INSERT INTO incident_ppe (name, description, created_by, organization) VALUES (?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org]);
//         await insertActivityLog(req.user.sessionid, "create", "IncidentPpe", `This user created a new IncidentPpe '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

export const createUpdateIncidentPpe = async (req, res) => {
  let { id, description, organization, department,name } = req.body;
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "IncidentPpe",
      "incident_ppe",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "incident_ppe",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "IncidentPpe name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "IncidentPpe name name  already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(IncidentPpe, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "IncidentPpe", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(IncidentPpe, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "IncidentPpe",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // req.body.description = await encodeSingle_statement(description);

  // req.body[req.body.id ? "updated_by" : "created_by"] = req.user.sessionid;

  // /**If id comes in body then it will update the query */
  // if (id) {
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       404,
  //       "Please Select at least one business Structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     IncidentPpe,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }

  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "Illness type",
  //     `This user Update Illness type which id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const unique_id = await uniqueIdGenerator(
  //     organization,
  //     department,
  //     "IPPE",
  //     "incident_ppe",
  //     "unique_id",
  //     "unique_id"
  //   );
  //   req.body.unique_id = unique_id;
  //   const insertPromises = organization.map(async (element) => {
  //     // Check if the category type already exists for the organization
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM incident_ppe WHERE name = ? AND deleted = "0" AND organization = ?`,
  //       [req.body.name, element]
  //     );
  //     if (req.body.parent) {
  //       const [checkName] = await db.query(
  //         `SELECT name FROM incident_ppe WHERE id = ${req.body.parent}`
  //       );
  //       const [newParent] = await db.query(
  //         `SELECT id FROM incident_ppe WHERE name  = '${checkName[0].name}' AND organization = ${element}`
  //       );
  //       req.body.parent = newParent[0].id;
  //     }

  //     req.body.organization = element;
  //     if (checkNameWithOrganization.length === 0) {
  //       const { query, values } = createQueryBuilder(IncidentPpe, {
  //         ...req.body,
  //         organization: element,
  //       });
  //       // console.log(query, values);
  //       await db.query(query, values);

  //       // Insert record for activity log
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "Illness type",
  //         `This user created a new incident ppe '${req.body.name}' for this organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/** Function to view all or single IncidentPpe */
export const viewIncidentPpe = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "incident_ppe"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "incident_ppe.name",
    "incident_ppe.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = incident_ppe.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let incidentPpeQuery = `SELECT 
  incident_ppe.*, 
  incident_ppe.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM incident_ppe
${joinsRecord} 
WHERE incident_ppe.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [incidentPpe] = await db.query(incidentPpeQuery);
  incidentPpe = await getListingData(incidentPpe);
  /**Count all organization */
  const totalRecord = await countQueryCondition(incidentPpeQuery);
  return sendResponse(res, 200, incidentPpe, totalRecord);

  // const { id } = req.params;
  // const { dropdown } = req.query;

  // const condition = await whereCondition({
  //   table: "incident_ppe",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchFields = [
  //   "incident_ppe.name",
  //   "incident_ppe.description",
  //   "users.name",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchFields
  // );
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = incident_ppe.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = incident_ppe.organization",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "incident_ppe AS parent_incident_ppe",
  //     onCondition: "parent_incident_ppe.id = incident_ppe.parent",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // // const fetchQuery = `SELECT incident_ppe.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name, FROM incident_ppe ${joinsRecord} WHERE incident_ppe.deleted = 0 ${searchCondition} ${condition}`;
  // // let [records] = await db.query(fetchQuery);

  // let fetchQuery = `SELECT incident_ppe.id, incident_ppe.unique_id, incident_ppe.created_by as created_by_id, incident_ppe.name,parent_incident_ppe.name AS parent_name , incident_ppe.description, users.name as created_by, users.surname as created_by_surname, users.profile as created_by_profile, organization.name as organization_name, incident_ppe.organization, incident_ppe.parent FROM incident_ppe ${joinsRecord} WHERE incident_ppe.deleted = 0 ${searchCondition} ${condition}`;
  // // fetchQuery = fetchQuery.replace("ORDER BY incident_ppe.id DESC", "ORDER BY incident_ppe.id ASC");
  // const [IncidentPPE] = await db.query(fetchQuery);

  // async function fetchSubChildren(parentId) {
  //   const [subChildren] = await db.query(
  //     `SELECT * FROM incident_ppe WHERE deleted = 0 AND parent = ?`,
  //     [parentId]
  //   );

  //   // Only populate sub-children if any are found, and no need to recurse if not needed
  //   for (const child of subChildren) {
  //     child.description = await decodeSingle_statement(child.description);
  //     child.sub_children = await fetchSubChildren(child.id);
  //   }
  //   return subChildren;
  // }

  // // Map through IncidentPPE and only populate the parent along with its sub-children.
  // const nestedIncidentPPEs = [];

  // for (const item of IncidentPPE) {
  //   item.description = await decodeSingle_statement(item.description);

  //   // Fetch the nested sub_children only for the top-level items.
  //   if (item.parent === null) {
  //     // Populate organizations for grouped data
  //     if (req.query.grouped == "true") {
  //       const [organizations] = await db.query(
  //         `SELECT organization FROM incident_ppe WHERE deleted = 0 AND name = ?`,
  //         [item.name]
  //       );
  //       const arr = organizations.map((item) => item.organization);
  //       item.organizations = arr;
  //     }
  //     // Fetch and add sub-children to the current illness type
  //     item.sub_children = await fetchSubChildren(item.id);
  //     nestedIncidentPPEs.push(item); // Push only the parent with its nested structure
  //   } else if (dropdown != 1 || id) {
  //     nestedIncidentPPEs.push(item);
  //   }
  // }

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(`SELECT organization FROM incident_ppe WHERE deleted = 0 AND name = ?`, [
  //       record.name,
  //     ]);
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  // const totalRecord = await countQueryCondition(fetchQuery);
  // return sendResponse(res, 200, nestedIncidentPPEs, totalRecord);
};

export const getParentIncidentPpeList = async (req, res) => {
  let { filter } = req.query;
  filter = typeof filter === "string" ? JSON.parse(filter) : filter;
  let { organizations } = filter;
  console.log(organizations);
  if (!organizations || organizations.length == 0) {
    const [arrOrg] = await db.query(
      `SELECT id FROM organization WHERE deleted = 0`
    );
    organizations = arrOrg.map((item) => item.id);
    // return sendResponse(res, 400, "organizations is required");
  }
  // console.log(organizations);
  organizations =
    typeof organizations == "string"
      ? JSON.parse(organizations)
      : organizations;
  const parentIncidentPpeQuery = `SELECT r1.*
          FROM incident_ppe r1
          JOIN (
            SELECT name
            FROM incident_ppe
            WHERE organization IN (${organizations})
            GROUP BY name
            HAVING COUNT(DISTINCT organization) = ${organizations.length}
          )  r2 ON r1.name = r2.name
          WHERE r1.organization IN (${organizations}) AND r1.deleted = 0;
          `;
  // console.log(parentIncidentPpeQuery, "parentIncidentPpeQuery")
  const [parentIncidentPpeList] = await db.query(parentIncidentPpeQuery);
  const uniqueObj = {};
  parentIncidentPpeList.forEach((item) => {
    if (!uniqueObj[item.name]) {
      uniqueObj[item.name] = item;
    }
  });
  const uniqueArr = Object.values(uniqueObj);
  // console.log(uniqueArr);
  // return uniqueArr;

  return sendResponse(res, 200, uniqueArr);
};

/** Function to delete IncidentPpe */
export const deleteIncidentPpe = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("incident_ppe", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "IncidentPpe", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
