import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getRecord,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import MaterialClassification from "../sequelize/MaterialClassificationSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { createQueryBuilder, updateQueryBuilder } from "../helper/queryBuilder.js";

/**Function to create new Material Classification for employee  */
export const createUpdateMaterialClassification = async (req, res) => {
  const { id, name, description, organization, department } = req.body;
  
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "MaterialClassification",
      "material_classification",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "material_classification",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "MaterialClassification name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "MaterialClassification name name  already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(MaterialClassification, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "MaterialClassification", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(MaterialClassification, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "MaterialClassification",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }
  
  
  
  
  
  
  
  
  
  // const encodedDescription = await encodeSingle_statement(description);

  // /**If id comes in body then it will update the query */
  // if (id) {
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       200,
  //       "Please select at least one business structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     MaterialClassification,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }

  //   /**Insert record for activity log */
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "material Classification",
  //     `This user Update material Classification which id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const unique_id = await uniqueIdGenerator(
  //     organization,
  //     department,
  //     "WMC",
  //     "material_classification",
  //     "unique_id",
  //     "unique_id"
  //   );
  //   req.body.unique_id = unique_id;
  //   /** Insert new record */
  //   const insertPromises = organization.map(async (element) => {
  //     // Check if the category type already exists for the organization
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM material_classification WHERE name = ? AND deleted = "0" AND organization = ?`,
  //       [name, element]
  //     );

  //     // If record not found for that name with particular organization, insert the record
  //     if (checkNameWithOrganization.length === 0) {
  //       // Insert material Classification details
  //       const insertMaterialClassificationQuery = `INSERT INTO material_classification(name, description, created_by, organization, unique_id) VALUES (?, ?, ?, ?, ?)`;
  //       await db.query(insertMaterialClassificationQuery, [
  //         name,
  //         encodedDescription,
  //         req.user.sessionid,
  //         element,
  //         unique_id,
  //       ]);

  //       // Insert record for activity log
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "Material Classification",
  //         `This user created a new category '${name}' for this organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/**Function to view all and single Material Classification */
export const viewMaterialClassification = async (req, res) => {
  
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "material_classification"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "material_classification.name",
    "material_classification.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = material_classification.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let materialClassificationQuery = `SELECT 
  material_classification.*, 
  material_classification.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM material_classification
${joinsRecord} 
WHERE material_classification.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [materialClassification] = await db.query(materialClassificationQuery);
  materialClassification = await getListingData(materialClassification);
  /**Count all organization */
  const totalRecord = await countQueryCondition(materialClassificationQuery);
  return sendResponse(res, 200, materialClassification, totalRecord);

  
  
  
  
  
  
  
  
  
  
  
  // const { id } = req.params;

  // const condition = await whereCondition({
  //   table: "material_classification",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchTableName = [
  //   "material_classification.name",
  //   "material_classification.description",
  //   "CONCAT(users.name , ' ' , users.surname)",
  //   "organization.name",
  // ];
  // /** If value come with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /**Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = material_classification.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = material_classification.organization",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "department",
  //     onCondition: "department.id = material_classification.department",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const materialClassificationQuery = `SELECT material_classification.*,users.id AS created_by_id, users.name AS created_by, organization.name AS organization_name , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM material_classification ${joinsRecord} where material_classification.deleted = 0 ${searchCondition} ${condition}`;
  // // return console.log(
  // //   materialClassificationQuery,
  // //   "materialClassificationQuery"
  // // );
  // let [materialClassificationRecord] = await db.query(materialClassificationQuery);

  // for (const item of materialClassificationRecord) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM material_classification WHERE deleted = 0 AND name = ?`,
  //       [item.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  // /**Count all organization */
  // const totalRecord = await countQueryCondition(materialClassificationQuery);

  // return sendResponse(res, 200, materialClassificationRecord, totalRecord);
};

/**Function to delete a specific Material Classification */
export const deleteMaterialClassification = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("material_classification", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Material Classification",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
