import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  updateQueryBuilder,
  createQueryBuilder,
  getFilterConditions,
  getListingData,
  getRecord,
} from "../helper/general.js";
import PurposeOfTraining from "../sequelize/PurposeOfTrainingSchema.js";

/** Function to create or update PurposeOfTraining */
export const createUpdatePurposeOfTraining = async (req, res) => {
  const { id, name,organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  const [checkNameWithOrganization] = await getRecord("purpose_of_training", "name", name);
    if (checkNameWithOrganization) {
      if (id && checkNameWithOrganization.id != id) {
        return sendResponse(res, 400, "Purpose of training name already exist");
      } else if (!id) {
        return sendResponse(res, 400, "Purpose of training name already exist");
      }
    }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "PurposeOfTraining",
      "purpose_of_training",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(PurposeOfTraining, req.body)
    : createQueryBuilder(PurposeOfTraining, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "PurposeOfTraining", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdatePurposeOfTraining = async (req, res) => {
//   const { id, name, description } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       PurposeOfTraining,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "PurposeOfTraining", `This user updated PurposeOfTraining with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM purpose_of_training WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//          const unique_id = await uniqueIdGenerator(
//             org,
//             req?.body?.department || null,
//             "PurposeOfTraining",
//             "purpose_of_training",
//             "unique_id",
//             "unique_id"
//           );

//         await db.query(`INSERT INTO purpose_of_training (name, description, created_by, organization,unique_id) VALUES (?,?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
//         await insertActivityLog(req.user.sessionid, "create", "PurposeOfTraining", `This user created a new PurposeOfTraining '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/** Function to view all or single PurposeOfTraining */
export const viewPurposeOfTraining = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "purpose_of_training");
  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "purpose_of_training",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = [
    "purpose_of_training.name",
    "purpose_of_training.description",
    "users.name",
  ];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    { type: "left", targetTable: "users", onCondition: "users.id = purpose_of_training.created_by" },
    // { type: "left", targetTable: "organization", onCondition: "organization.id = purpose_of_training.organization" }
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT purpose_of_training.*, users.name AS created_by, users.surname as created_by_surname, purpose_of_training.organization AS organizations FROM purpose_of_training ${joinsRecord} WHERE purpose_of_training.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);
  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //    if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM purpose_of_training WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete PurposeOfTraining */
export const deletePurposeOfTraining = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("purpose_of_training", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "PurposeOfTraining", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
