import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFilterConditions,
  getListingData,
  getFirstCreatedAndAllOrganizationIds,
  getRecord,
} from "../helper/general.js";
import QualityIncidentType from "../sequelize/QualityIncidentTypeSchema.js";
import {
  createQueryBuilder,
  updateQueryBuilder,
} from "../helper/queryBuilder.js";

/** Function to create or update QualityIncidentType */
export const createUpdateQualityIncidentType = async (req, res) => {
  const { id, name, description, organization } = req.body;

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "QualityIncidentType",
      "quality_incident_type",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "quality_incident_type",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Quality Incident Type name already exist");
    } else if (!id) {
      return sendResponse(
        res,
        400,
        "Quality Incident Type name  already exist"
      );
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(QualityIncidentType, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "update",
      "QualityIncidentType",
      id
    );
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(QualityIncidentType, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "QualityIncidentType",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);

  // if (id) {
  //   const result = await settingsUpdater(
  //     QualityIncidentType,
  //     req.body.organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }
  //   await insertActivityLog(req.user.sessionid, "update", "QualityIncidentType", `This user updated QualityIncidentType with id: ${id}`);
  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const insertPromises = req.body.organization.map(async (org) => {
  //     const [checkName] = await db.query(`SELECT name FROM quality_incident_type WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
  //     if (checkName.length === 0) {
  //       const unique_id = await uniqueIdGenerator(
  //         org,
  //         req.body?.department,
  //         "QIT",
  //         "quality_incident_type",
  //         "unique_id",
  //         "unique_id"
  //       );
  //       await db.query(`INSERT INTO quality_incident_type (name, description, created_by, organization,unique_id) VALUES (?,?, ?, ?, ?)`, [name, encodedDescription, req.user.sessionid, org,unique_id]);
  //       await insertActivityLog(req.user.sessionid, "create", "QualityIncidentType", `This user created a new QualityIncidentType '${name}' for organization ${org}`);
  //     }
  //   });
  //   await Promise.all(insertPromises);
  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/** Function to view all or single QualityIncidentType */
export const viewQualityIncidentType = async (req, res) => {
 
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "quality_incident_type"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "quality_incident_type.name",
    "quality_incident_type.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = quality_incident_type.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let qualityIncidentTypeQuery = `SELECT 
  quality_incident_type.*, 
  quality_incident_type.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM quality_incident_type
${joinsRecord} 
WHERE quality_incident_type.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [qualityIncidentType] = await db.query(qualityIncidentTypeQuery);
  qualityIncidentType = await getListingData(qualityIncidentType);
  /**Count all organization */
  const totalRecord = await countQueryCondition(qualityIncidentTypeQuery);
  return sendResponse(res, 200, qualityIncidentType, totalRecord);
 
 
 
 
 
 
 
 
 
  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "quality_incident_type",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   // grouped: req.query.grouped,
  // });

  // const searchFields = [
  //   "quality_incident_type.name",
  //   "quality_incident_type.description",
  //   "users.name",
  //   "organization.name",
  // ];
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchFields
  // );
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = quality_incident_type.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = quality_incident_type.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const fetchQuery = `SELECT quality_incident_type.*, CONCAT(users.name, ' ', users.surname) AS created_by, organization.name AS organization_name FROM quality_incident_type ${joinsRecord} WHERE quality_incident_type.deleted = 0 ${searchCondition} ${condition}`;
  // let [records] = await db.query(fetchQuery);

  // for (const record of records) {
  //   //       const unique_id = await uniqueIdGenerator(
  //   //         record?.organization,
  //   //         record?.department,
  //   //         "QIT",
  //   //         "quality_incident_type",
  //   //         "unique_id",
  //   //         "unique_id",
  //   //         record?.id
  //   //       );
  //   // console.log("id",record?.id)
  //   // console.log("unique_id---------",unique_id)
  //   // record.unique_id = unique_id
  //   record.description = await decodeSingle_statement(record.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM quality_incident_type WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;

  //     // await db.query(`UPDATE quality_incident_type SET  unique_id = '${unique_id}' WHERE id = ${record.id} `)
  //   }
  // }

  // const totalRecord = await countQueryCondition(fetchQuery);
  // return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete QualityIncidentType */
export const deleteQualityIncidentType = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("quality_incident_type", id);
  if (deleteRecord) {
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "QualityIncidentType",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
