import db from "../db-config.js";
import {
  checkNameInOrganization,
  countQueryCondition,
  createQueryBuilder,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getOrganizationAccordingToDepartment,
  getRecord,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import Responsibility from "../sequelize/ResponsibilitySchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { updateQueryBuilder } from "../helper/queryBuilder.js";

/**Function to create or update Responsibilities  */
export const createUpdateResponsibility = async (req, res) => {
  const { id, name, description, organization, department = null } = req.body;
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();
    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "Responsibility",
      "responsibility",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "responsibility",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Responsibility name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Responsibility name already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(Responsibility, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "Responsibility", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(Responsibility, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "Responsibility",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }

  // const encodedDescription = await encodeSingle_statement(description);
  // req.body.description = encodedDescription;

  // /**Check record if organization is not coming then fetch organization according to department */
  // let organizationId = organization;
  // if (department) {
  //   const recordAccordingToOrganization =
  //     await getOrganizationAccordingToDepartment(department);
  //   organizationId = recordAccordingToOrganization[0].organization;
  // }

  // /**If id come then update that record  */

  // if (id) {
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       400,
  //       "Please Select at least one business Structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     Responsibility,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 400, "No data found");
  //   }
  //   /**Insert Activity  */
  //   await insertActivityLog(req.user.sessionid, "update", "Responsibility", id);

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   const insertPromise = organizationId.map(async (element) => {
  //     /**Check that this organization have that particular name or not*/
  //     const checkNameWithOrganization = await checkNameInOrganization(
  //       "responsibility",
  //       name,
  //       element
  //     );
  //     if (checkNameWithOrganization.length === 0) {
  //       /**Insert query record */
  //       req.body.created_by = req.user.sessionid;
  //       req.body.organization = element;

  //       if(!id){
  //         const unique_id = await uniqueIdGenerator(
  //           req.body.organization,
  //           department,
  //           "Responsibility",
  //           "responsibility",
  //           "unique_id",
  //           "unique_id"
  //         );
  //         req.body.unique_id = unique_id;
  //       }

  //       // const { query, values } = createQueryBuilder(Responsibility, req.body);
  //       const { query, values } = createQueryBuilder(Responsibility, {
  //         ...req.body,
  //         organization: element,
  //       });

  //       const recordInsertResponsibility = await db.query(query, values);

  //       /**Insert record for activity log */
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "Responsibility",
  //         recordInsertResponsibility.insertId
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromise);
  // }
  // return sendResponse(res, 200, "Record created successfully");
};
/**Function to view all  responsibility */
export const viewAllResponsibility = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "responsibility"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "responsibility.name",
    "responsibility.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = responsibility.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let responsibilityQuery = `SELECT 
  responsibility.*, 
  responsibility.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM responsibility
${joinsRecord} 
WHERE responsibility.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [responsibility] = await db.query(responsibilityQuery);
  responsibility = await getListingData(responsibility);
  /**Count all organization */
  const totalRecord = await countQueryCondition(responsibilityQuery);
  return sendResponse(res, 200, responsibility, totalRecord);

  // const { id } = req.params;

  // const condition = await whereCondition({
  //   table: "responsibility",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   grouped: req.query.grouped,
  //   user: req.user,
  // });

  // const searchTableName = [
  //   "responsibility.name",
  //   "responsibility.description",
  //   "createdUser.name",
  //   "createdUser.surname",
  //   "organization.name",
  // ];
  // /** If value come with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /**Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = responsibility.organization",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "users as createdUser",
  //     onCondition: "createdUser.id = responsibility.created_by",
  //   },
  // ];

  // const joinsRecord = await makeJoins(joins);

  // /**Record of all responsibility */
  // const responsibilityQuery = `SELECT responsibility.* , organization.name as organization_name, createdUser.name as created_by , createdUser.surname as created_by_surname , createdUser.id as created_by_id , createdUser.profile as created_by_profile
  //   FROM responsibility
  //   ${joinsRecord} where responsibility.deleted = 0  ${searchCondition} ${condition}`;
  // const [responsibility] = await db.query(responsibilityQuery);

  // for (const resp of responsibility) {
  //   resp.description = await decodeSingle_statement(resp.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM responsibility WHERE deleted = 0 AND name = ?`,
  //       [resp.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     resp.organizations = arr;
  //   }
  // }

  // const totalRecord = await countQueryCondition(responsibilityQuery);

  // return sendResponse(res, 200, responsibility, totalRecord);
};

/**Function to delete a specific responsibility */
export const deleteResponsibility = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("responsibility", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Responsibility", id);
    return sendResponse(res, 200, "Responsibility deleted successfully");
  }
};
