import db from "../db-config.js";
import {
  countQueryCondition,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  getRecord,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  whereCondition,
} from "../helper/general.js";
import RoleHierarchy from "../sequelize/RoleHierarchySchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { createQueryBuilder, updateQueryBuilder } from "../helper/queryBuilder.js";

/**Function to create new Role Hierarchy for employee  */
export const createUpdateRoleHierarchy = async (req, res) => {
  const { id, name, level, description, organization } = req.body;
  // const encodedDescription = await encodeSingle_statement(description);

  // /**If id comes in body then it will update the query */
  // if (id) {
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       200,
  //       "Please select at least one business structure"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     RoleHierarchy,
  //     organization,
  //     req.body,
  //     req.user
  //   );
  //   if (!result) {
  //     return sendResponse(res, 404, "No data found");
  //   }

  //   /**Insert record for activity log */
  //   await insertActivityLog(
  //     req.user.sessionid,
  //     "update",
  //     "Role Hierarchy",
  //     `This user Update Role Hierarchy which id is ${id}`
  //   );

  //   return sendResponse(res, 200, "Record updated successfully");
  // } else {
  //   /** Insert new record */
  //   const insertPromises = organization.map(async (element) => {
  //     // Check if the category type already exists for the organization
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM role_hierarchy WHERE name = ? AND deleted = "0" AND organization = ?`,
  //       [name, element]
  //     );

  //     // If record not found for that name with particular organization, insert the record
  //     if (checkNameWithOrganization.length === 0) {
  //       const unique_id = await uniqueIdGenerator(
  //         element,
  //         req.body?.department || null,
  //         "RoleHierarchy",
  //         "role_hierarchy",
  //         "unique_id",
  //         "unique_id"
  //       );

  //       // Insert Role Hierarchy details
  //       const insertRoleHierarchyQuery = `INSERT INTO role_hierarchy(name, description, level,created_by, organization, unique_id) VALUES (?, ?, ?, ?,?,?)`;

  //       await db.query(insertRoleHierarchyQuery, [
  //         name,
  //         encodedDescription,
  //         level,
  //         req.user.sessionid,
  //         element,
  //         unique_id,
  //       ]);

  //       // Insert record for activity log
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "Role Hierarchy",
  //         `This user created a new category '${name}' for this organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
   if (!id) {
      const result = await getFirstCreatedAndAllOrganizationIds();
      if (!result.firstOrgId) {
        return sendResponse(res, 404, "No organization found.");
      }
      const unique_id = await uniqueIdGenerator(
        result.firstOrgId,
        req.body?.department || null,
        "RoleHierarchy",
        "role_hierarchy",
        "unique_id",
        "unique_id"
      );
      req.body.unique_id = unique_id;
      req.body.organization = organization.length > 0 ? organization : result.organizationIds;
    }
  const encodedDescription = await encodeSingle_statement(description);
  req.body.description = encodedDescription;
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord("role_hierarchy", "name", name);
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Role Hierarchy name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Role Hierarchy already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(RoleHierarchy, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "RoleHierarchy", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(RoleHierarchy, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "RoleHierarchy",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }
};

/**Function to view all and single RoleHierarchy */
export const viewRoleHierarchy = async (req, res) => {

  let {organizationCondition, condition} = await getFilterConditions(req, db, "role_hierarchy");
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "role_hierarchy.name",
    "role_hierarchy.description",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = role_hierarchy.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let roleHierarchyQuery = `SELECT 
  role_hierarchy.*, 
  role_hierarchy.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM role_hierarchy
${joinsRecord} 
WHERE role_hierarchy.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [roleHierarchy] = await db.query(roleHierarchyQuery);
    roleHierarchy = await getListingData(roleHierarchy)
  /**Count all organization */
  const totalRecord = await countQueryCondition(roleHierarchyQuery);
  return sendResponse(res, 200, roleHierarchy, totalRecord);




  // const { id } = req.params;

  // const condition = await whereCondition({
  //   table: "role_hierarchy",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  // const searchTableName = [
  //   "role_hierarchy.name",
  //   "role_hierarchy.description",
  //   "CONCAT(users.name , ' ' , users.surname)",
  //   "organization.name",
  // ];
  // /** If value come with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /**Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users",
  //     onCondition: "users.id = role_hierarchy.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = role_hierarchy.organization",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "department",
  //     onCondition: "department.id = role_hierarchy.department",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // const RoleHierarchyQuery = `SELECT role_hierarchy.*,users.id AS created_by_id, users.name AS created_by, organization.name AS organization_name , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM role_hierarchy ${joinsRecord} where role_hierarchy.deleted = 0 ${searchCondition} ${condition}`;
  // // console.log("RoleHierarchyQuery: ", RoleHierarchyQuery);

  // let [RoleHierarchyRecord] = await db.query(RoleHierarchyQuery);

  // for (const item of RoleHierarchyRecord) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM role_hierarchy WHERE deleted = 0 AND name = ?`,
  //       [item.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  // /**Count all organization */
  // const totalRecord = await countQueryCondition(RoleHierarchyQuery);

  // return sendResponse(res, 200, RoleHierarchyRecord, totalRecord);
};

/**Function to delete a specific Role Hierarchy */
export const deleteRoleHierarchy = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("role_hierarchy", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "RoleHierarchy", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
