import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  insertActivityLog,
  searchConditionRecord,
  makeJoins,
  whereCondition,
  countQueryCondition,
  settingsUpdater,
  deleteSettingRecord,
  encodeSingle_statement,
  decodeSingle_statement,
  uniqueIdGenerator,
  getFirstCreatedAndAllOrganizationIds,
  encodeAndStringifyFields,
  updateQueryBuilder,
  createQueryBuilder,
  getFilterConditions,
  getListingData,
} from "../helper/general.js";
import SopCategory from "../sequelize/SopCategorySchema.js";

/** Function to create or update SopCategory */
export const createUpdateSopCategory = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "SOPC",
      "sop_category",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id ? updateQueryBuilder(SopCategory, req.body) : createQueryBuilder(SopCategory, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "SopCategory", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateSopCategory = async (req, res) => {
//   const { id, name, description, department } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   if (id) {
//     const result = await settingsUpdater(
//       SopCategory,
//       req.body.organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }
//     await insertActivityLog(req.user.sessionid, "update", "SopCategory", `This user updated SopCategory with id: ${id}`);
//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     const unique_id = await uniqueIdGenerator(
//       req.body.organization,
//       department,
//       "SOPC",
//       "sop_category",
//       "unique_id",
//       "unique_id"
//     );
//     req.body.unique_id = unique_id;
//     const insertPromises = req.body.organization.map(async (org) => {
//       const [checkName] = await db.query(`SELECT name FROM sop_category WHERE name = ? AND deleted = 0 AND organization = ?`, [name, org]);
//       if (checkName.length === 0) {
//         await db.query(`INSERT INTO sop_category (name, description, created_by, organization, unique_id) VALUES (?, ?, ?, ?, ?)`,
//           [name, encodedDescription, req.user.sessionid, org, req.body.unique_id]);
//         await insertActivityLog(req.user.sessionid, "create", "SopCategory", `This user created a new SopCategory '${name}' for organization ${org}`);
//       }
//     });
//     await Promise.all(insertPromises);
//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/** Function to view all or single SopCategory */
export const viewSopCategory = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "sop_category");

  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "sop_category",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchFields = ["sop_category.name", "sop_category.description", "users.name", "organization.name"];
  let searchCondition = await searchConditionRecord(req.query.search, searchFields);
  const joins = [
    { type: "left", targetTable: "users", onCondition: "users.id = sop_category.created_by" },
    // { type: "left", targetTable: "organization", onCondition: "organization.id = sop_category.organization" }
  ];
  const joinsRecord = await makeJoins(joins);

  const fetchQuery = `SELECT sop_category.*, CONCAT(users.name, ' ', users.surname) AS created_by, sop_category.organization AS organizations FROM sop_category ${joinsRecord} WHERE sop_category.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  let [records] = await db.query(fetchQuery);

  records = await getListingData(records);

  // for (const record of records) {
  //   record.description = await decodeSingle_statement(record.description);
  //     if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM sop_category WHERE deleted = 0 AND name = ?`,
  //       [record.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     record.organizations = arr;
  //   }
  // }

  const totalRecord = await countQueryCondition(fetchQuery);
  return sendResponse(res, 200, records, totalRecord);
};

/** Function to delete SopCategory */
export const deleteSopCategory = async (req, res) => {
  const { id } = req.params;
  const deleteRecord = await deleteSettingRecord("sop_category", id);
  if (deleteRecord) {
    await insertActivityLog(req.user.sessionid, "delete", "SopCategory", id);
    return sendResponse(res, 200, "Record deleted successfully");
  } else {
    return sendResponse(res, 404, "Record not found");
  }
};
