import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
  countQueryCondition,
  whereCondition,
  searchConditionRecord,
  makeJoins,
  insertActivityLog,
  deleteRecord,
  getOrganizationAccordingToDepartment,
  updateQueryBuilder,
  createQueryBuilder,
  decodeAndParseFields,
  uploadFile,
  processUploadDocuments,
  uniqueIdGenerator,
  paginateRecords,
} from "../helper/general.js";
import TrainingAttendance from "../sequelize/TrainingAttendanceRecordingSchema.js";
import TrainingAttendanceRecordingDocs from "../sequelize/TrainingAttendanceRecordingDocsSchema.js";
import FileClassification from "../sequelize/FileClassificationSchema.js";

export const createUpdateAttendanceRecording = async (req, res) => {
  const { id, sidebar_id = 209, upload_documents } = req.body;

  const [fetchOrganization] = await db.query(
    `SELECT organization , department FROM training_schedule WHERE id = ${req.body.training_program}`
  );

  req.body.organization = fetchOrganization[0]?.organization;
  req.body.department = fetchOrganization[0]?.department;

  const documents = await processUploadDocuments(req, sidebar_id);

  if (id && documents.length) {
    const deleteQuery = `UPDATE attendance_recording_docs SET deleted = 1 where deleted = 0 AND attendance_recording_id = ?`;
    await db.query(deleteQuery, [id]);
  }
  if (id) {
    await deleteRecord(
      TrainingAttendanceRecordingDocs,
      id,
      "attendance_recording_id"
    );
  } else {
    const unique_id = await uniqueIdGenerator(
      req.body.organization,
      req.body.department,
      "TrainingAttendance",
      "attendance_recording",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
  }

  // console.log(req.body.upload_documents);
  // for (let i = 0; req.body[`upload_documents[${i}][title]`] !== undefined; i++) {
  //   const id = i + 1;
  //   const title = req.body[`upload_documents[${i}][title]`];
  //   const file = req.files && req.files[`upload_documents[${i}][file]`];
  //   const classification = req.body[`upload_documents[${i}][classification]`];
  //   // Extract the index from the key
  //   // Assuming you want to store the file in a folder named "uploads"
  //   let filepath = "";
  //   if (typeof file !== "string" && typeof file !== "undefined" && file !== null) {
  //     filepath = await uploadFile("attendance_recording", file);
  //   } else {
  //     filepath = req.body[`upload_documents[${i}][file]`];
  //   }
  //   // Move the file to the desired location
  //   // Push document information to the array
  //   documents.push({ id, title, file: filepath, classification });
  // }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;

  const { query, values } = id
    ? updateQueryBuilder(TrainingAttendance, req.body)
    : createQueryBuilder(TrainingAttendance, req.body);
  let [result] = await db.query(query, values);

  // if (documents || Array.isArray(documents)) {
  //   // Iterate through uploaded files
  //   for (const file of documents) {
  //     const title = file.title; // Use file name as title
  //     const ddrm_id = file?.ddrm_id;
  //     const id_doc = file.id;
  //     const classification = file.classification;
  //     // Move the file to the public folder
  //     // Save file details for database
  //     const { query: docQuery, values: docValues } = createQueryBuilder(TrainingAttendanceRecordingDocs, {
  //       doc_no: id_doc,
  //       attendance_recording_id: id ? id : result.insertId,
  //       title,
  //       classification,
  //       ddrm_id,
  //     });

  //     await db.query(docQuery, docValues);
  //   }
  // }

  if (upload_documents || Array.isArray(upload_documents)) {
    const uploadDocArray = JSON.parse(upload_documents);
    // Iterate through uploaded files
    for (let file of uploadDocArray) {
      const title = file?.title; // Use file name as title
      const ddrm_id = file?.ddrm_id;
      const id_doc = file?.id;
      const classification = file?.classification;
      // Move the file to the public folder
      // Save file details for database
      const { query: docQuery, values: docValues } = createQueryBuilder(
        TrainingAttendanceRecordingDocs,
        {
          doc_no: id_doc,
          attendance_recording_id: id ? id : result.insertId,
          title,
          classification,
          ddrm_id,
        }
      );

      await db.query(docQuery, docValues);
    }
  }

  // for (const doc of documents) {
  //   const { query, values } = createQueryBuilder(TrainingAttendanceRecordingDocs, {
  //     attendance_recording_id: id ? id : result.insertId,
  //     ...doc,
  //   });
  //   // console.log(query, values);
  //   await db.query(query, values);
  // }

  await insertActivityLog(
    req.user.sessionid,
    "update",
    `TrainingAttendance Record is updated for this organization ${req.body.organization}`,
    id ? id : result.insertId
  );
  return sendResponse(res, 200, `Record ${status} successfully`);
};

export const getAttendanceRecording = async (req, res) => {
  const { id } = req.params;
  const condition = await whereCondition({
    table: "attendance_recording",
    page: req.query.page,
    all: req.query.all,
    pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = [
    // "attendance_recording.actual_training_service_provider",
    "training_need_analysis.training_name",
    "attendance_recording.training_venue",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "training_schedule",
      onCondition:
        "training_schedule.id = attendance_recording.training_program",
    },
    {
      type: "left",
      targetTable: "training_need_analysis",
      onCondition:
        "training_need_analysis.id = training_schedule.training_program",
    },
    {
      type: "left",
      targetTable: "purpose_of_training",
      onCondition:
        "purpose_of_training.id = training_need_analysis.training_purpose",
    },
    {
      type: "left",
      targetTable: "contractor_registration",
      onCondition: "contractor_registration.id = attendance_recording.company",
    },
    {
      type: "left",
      targetTable: "users as employee",
      onCondition: "employee.id = attendance_recording.employee",
    },
    {
      type: "left",
      targetTable: "currency",
      onCondition: "currency.id = attendance_recording.currency",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "attendance_recording.organization = organization.id",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const attendanceRecordingQuery = `SELECT 
    attendance_recording.* , training_need_analysis.training_name AS training_program_name  , training_need_analysis.training_purpose , training_need_analysis.training_type , 
    purpose_of_training.name AS training_purpose_name ,
    CONCAT(employee.name , ' ' , employee.surname) AS employee_name ,
    contractor_registration.contractor_name AS company_name ,
    currency.name AS currency_name ,
    organization.name AS organization_name
    FROM attendance_recording ${joinCondition} WHERE attendance_recording.deleted = 0  ${searchCondition} ${condition}`;

  let [attendanceRecording] = await db.query(attendanceRecordingQuery);
  attendanceRecording = await decodeAndParseFields(attendanceRecording);
  for (const recording of attendanceRecording) {
    // const docs = await TrainingAttendanceRecordingDocs.findAll({
    //   where: {
    //     attendance_recording_id: recording.id,
    //     deleted: 0,
    //   },
    //   attributes: ["file", "title", "classification"],
    //   include: {
    //     model: FileClassification,
    //     attributes: ["name"],
    //     as: "classification_details",
    //   },
    // });
    // recording.documents = docs;

    const [files] = await db.query(
      `SELECT attendance_recording_docs.*, document_creation.document_name as title , file_classification.name as classification_name , repository.url as file FROM attendance_recording_docs  LEFT JOIN file_classification ON 
      attendance_recording_docs.classification = file_classification.id 
       LEFT JOIN repository ON repository.id = attendance_recording_docs.ddrm_id LEFT JOIN document_creation ON document_creation.id = repository.document_creation_id WHERE attendance_recording_docs.deleted = 0 AND attendance_recording_id = ${recording.id}`
    );

    recording.documents =
      files.length > 0
        ? files
        : [{ title: "", classification: "", file: "", ddrm_id: "" }];
  }
  const totalRecord = await countQueryCondition(attendanceRecordingQuery);

  return sendResponse(res, 200, attendanceRecording, totalRecord);
};

export const deleteAttendanceRecording = async (req, res) => {
  const { id } = req.params;
  await deleteRecord("attendance_recording", id);
  await insertActivityLog(
    req.user.sessionid,
    "delete",
    "TrainingAttendance Record has been deleted by this user",
    id
  );
  return sendResponse(res, 200, "Record deleted successfully");
};

// export const getTrainingReport = async (req, res) => {
//   const { id } = req.params;
//   const { training_date } = req.query;
//   const condition = await whereCondition({
//     table: "attendance_recording",
//     page: req.query.page,
//     all: req.query.all,
//     pageSize: req.query.pageSize,
//     filter: req.query.filter,
//     id,
//     grouped: req.query.grouped,
//     user: req.user,
//   });

//   const searchTableName = [
//     "attendance_recording.actual_training_service_provider",
//     "attendance_recording.training_venue",
//   ];

//   const searchCondition = await searchConditionRecord(
//     req.query.search,
//     searchTableName
//   );

//   const joins = [
//     {
//       type: "left",
//       targetTable: "training_schedule",
//       onCondition:
//         "training_schedule.id = attendance_recording.training_program",
//     },
//     {
//       type: "left",
//       targetTable: "training_need_analysis",
//       onCondition:
//         "training_need_analysis.id = training_schedule.training_program",
//     },
//     {
//       type: "left",
//       targetTable: "purpose_of_training",
//       onCondition:
//         "purpose_of_training.id = training_need_analysis.training_purpose",
//     },
//     {
//       type: "left",
//       targetTable: "contractor_registration",
//       onCondition: "contractor_registration.id = attendance_recording.company",
//     },
//     {
//       type: "left",
//       targetTable: "users as employee",
//       onCondition: "employee.id = attendance_recording.employee",
//     },
//     {
//       type: "left",
//       targetTable: "currency",
//       onCondition: "currency.id = attendance_recording.currency",
//     },
//     {
//       type: "left",
//       targetTable: "organization",
//       onCondition: "attendance_recording.organization = organization.id",
//     },
//   ];

//   const joinCondition = await makeJoins(joins);

//   const attendanceRecordingQuery = `SELECT
//     attendance_recording.* , training_need_analysis.training_name AS training_program_name , training_need_analysis.training_purpose , training_need_analysis.training_type ,
//     purpose_of_training.name AS training_purpose_name ,
//     CONCAT(employee.name , ' ' , employee.surname) AS employee_name ,
//     contractor_registration.contractor_name AS company_name ,
//     currency.name AS currency_name ,
//     organization.name AS organization_name
//     FROM attendance_recording ${joinCondition} WHERE attendance_recording.deleted = 0  ${searchCondition} ${condition}`;

//   let [attendanceRecording] = await db.query(attendanceRecordingQuery);
//   const trainingReportList = [];
//   attendanceRecording = await decodeAndParseFields(attendanceRecording);
//   for (const recording of attendanceRecording) {
//     const docs = await TrainingAttendanceRecordingDocs.findAll({
//       where: {
//         attendance_recording_id: recording.id,
//         deleted: 0,
//       },
//       attributes: ["file", "title", "classification"],
//       include: {
//         model: FileClassification,
//         attributes: ["name"],
//         as: "classification_details",
//       },
//     });
//     recording.documents = docs;
//     // training report for each attendee with status completed or not
//     const attendees = recording?.attendees || [];
//     delete recording.attendees;
//     for (const attendee of attendees) {
//       const reportData = {
//         user_id: attendee.user_id,
//         name: attendee.name,
//         profile: attendee.profile,
//         surname: attendee.surname,
//         employee_id: attendee.employee_id,
//         status: attendee.status,
//         training_purpose_name: recording.training_purpose_name,
//         documents: recording.documents,
//         training_actual_date: recording.training_actual_date,
//         training_actual_time: recording.training_actual_time,
//         training_venue: recording.training_venue,
//         training_program_name: recording.training_program_name,
//       };
//       trainingReportList.push(reportData);
//     }
//   }
//   // const totalRecord = await countQueryCondition(attendanceRecordingQuery);
//   const totalTrainingReportList = [];
//   const totalCountQuery = attendanceRecordingQuery.substring(
//     0,
//     attendanceRecordingQuery.indexOf("ORDER BY")
//   );
//   let [totalAttendanceRecording] = await db.query(totalCountQuery);
//   totalAttendanceRecording = await decodeAndParseFields(
//     totalAttendanceRecording
//   );
//   // console.log(totalAttendanceRecording.length, "totalAttendanceRecording");
//   for (const recording of totalAttendanceRecording) {
//     // training report for each attendee with status completed or not
//     const attendees = recording?.attendees || [];
//     delete recording.attendees;
//     for (const attendee of attendees) {
//       const reportData = {
//         user_id: attendee.user_id,
//         name: attendee.name,
//         profile: attendee.profile,
//         surname: attendee.surname,
//         employee_id: attendee.employee_id,
//         status: attendee.status,
//         training_purpose_name: recording.training_purpose_name,
//         documents: recording.documents,
//       };
//       totalTrainingReportList.push(reportData);
//     }
//   }
//   // console.log(totalTrainingReportList, "totalTrainingReportList")
//   return sendResponse(
//     res,
//     200,
//     trainingReportList,
//     totalTrainingReportList.length
//   );
// };

export const getTrainingReport = async (req, res) => {
  const { id } = req.params;
  const { training_date } = req.query;
  const condition = await whereCondition({
    table: "attendance_recording",
    // page: req.query.page,
    // all: req.query.all,
    // pageSize: req.query.pageSize,
    filter: req.query.filter,
    id,
    grouped: req.query.grouped,
    user: req.user,
  });

  const searchTableName = [
    "attendance_recording.actual_training_service_provider",
    "attendance_recording.training_venue",
  ];

  const searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );

  const joins = [
    {
      type: "left",
      targetTable: "training_schedule",
      onCondition:
        "training_schedule.id = attendance_recording.training_program",
    },
    {
      type: "left",
      targetTable: "training_need_analysis",
      onCondition:
        "training_need_analysis.id = training_schedule.training_program",
    },
    {
      type: "left",
      targetTable: "purpose_of_training",
      onCondition:
        "purpose_of_training.id = training_need_analysis.training_purpose",
    },
    {
      type: "left",
      targetTable: "contractor_registration",
      onCondition: "contractor_registration.id = attendance_recording.company",
    },
    {
      type: "left",
      targetTable: "users as employee",
      onCondition: "employee.id = attendance_recording.employee",
    },
    {
      type: "left",
      targetTable: "currency",
      onCondition: "currency.id = attendance_recording.currency",
    },
    {
      type: "left",
      targetTable: "organization",
      onCondition: "attendance_recording.organization = organization.id",
    },
  ];

  const joinCondition = await makeJoins(joins);

  const attendanceRecordingQuery = `SELECT 
    attendance_recording.* , training_need_analysis.training_name AS training_program_name , training_need_analysis.training_purpose , training_need_analysis.training_type , 
    purpose_of_training.name AS training_purpose_name ,
    CONCAT(employee.name , ' ' , employee.surname) AS employee_name ,
    contractor_registration.contractor_name AS company_name ,
    currency.name AS currency_name ,
    organization.name AS organization_name
    FROM attendance_recording ${joinCondition} WHERE attendance_recording.deleted = 0  ${searchCondition} ${condition}`;

  let [attendanceRecording] = await db.query(attendanceRecordingQuery);
  const trainingReportList = [];
  attendanceRecording = await decodeAndParseFields(attendanceRecording);
  for (const recording of attendanceRecording) {
    const docs = await TrainingAttendanceRecordingDocs.findAll({
      where: {
        attendance_recording_id: recording.id,
        deleted: 0,
      },
      attributes: ["file", "title", "classification"],
      include: {
        model: FileClassification,
        attributes: ["name"],
        as: "classification_details",
      },
    });
    recording.documents = docs;
    // training report for each attendee with status completed or not
    const attendees = recording?.attendees || [];
    delete recording.attendees;
    for (const attendee of attendees) {
      const reportData = {
        user_id: attendee.user_id,
        name: attendee.name,
        profile: attendee.profile,
        surname: attendee.surname,
        employee_id: attendee.employee_id,
        status: attendee.status,
        training_purpose_name: recording.training_purpose_name,
        documents: recording.documents,
        training_actual_date: recording.training_actual_date,
        training_actual_time: recording.training_actual_time,
        training_venue: recording.training_venue,
        training_program_name: recording.training_program_name,
      };
      trainingReportList.push(reportData);
    }
  }
  const { data, totalRecords } = await paginateRecords(
    trainingReportList,
    req.query
  );
  return sendResponse(res, 200, data, totalRecords);
};
