import { ICalCalendar } from "ical-generator";
import fs from "fs";
import path from "path";

export async function createCalendar(arr) {
  // Create a new iCal calendar
  const cal = new ICalCalendar();

  // Add events to the calendar
  arr.forEach((obj) => {
    // console.log(obj);
    cal.createEvent({
      start: obj.planned_meeting_date_from,
      end: obj.planned_meeting_date_to,
      summary: obj.meeting_title || "demo",
      description: obj.meeting_title,
      location: obj.venue,
    });
  });

  const folderPath = "./public/calendar";
  const fileName = `calendar.ics`;
  const filePath = path.join(folderPath, fileName);
  try {
    /** Check if file exists */
    await fs.promises.access(filePath);
    /** If exists, unlink the file */
    await fs.promises.unlink(filePath);
  } catch (err) {
    /** Ignore error if file doesn't exist */
    if (err.code !== "ENOENT") {
      console.error("Error occurred while deleting the file:", err);
      // throw err;
    }
  }

  /** Generate the iCal data */
  const iCalData = cal.toString();

  /** Save the iCal data to a file */
  try {
    await fs.promises.writeFile(filePath, iCalData, "utf-8");
    console.log("iCalendar file generated successfully.");
    return { fileName, filePath };
  } catch (err) {
    console.error("Error occurred while writing iCalendar file:", err);
    // throw err;
  }
}

export async function getCalendar(
  arr,
  structureData = {
    start: "planned_meeting_date_from",
    end: "planned_meeting_date_to",
    summary: "meeting_title",
    description: "meeting_title",
    location: "venue",
  },
  file = "calender"
) {
  // Create a new iCal calendar
  const cal = new ICalCalendar();

  // Add events to the calendar
  arr.forEach((obj) => {
    // console.log(obj);
    if (obj[structureData.start] == null || obj[structureData.end] == null) {
      console.log(
        "Invalid date: ",
        obj[structureData.start],
        " ",
        obj[structureData.end]
      );
      return;
    }
    cal.createEvent({
      start: obj[structureData.start] || "",
      end: obj[structureData.end] || "",
      summary: obj[structureData.summary] || "demo",
      description: obj[structureData.description] || "",
      location: obj[structureData.location] || "",
    });
  });

  const publicDir = path.join(process.cwd(), "public");
  const folderPath = path.join(publicDir, "calendar");
  const fileName = `${file}.ics`;
  const filePath = path.join(folderPath, fileName);
  if (!fs.existsSync(folderPath)) {
    fs.mkdirSync(folderPath, { recursive: true });
  }
  try {
    /** Check if file exists */
    await fs.promises.access(filePath);
    /** If exists, unlink the file */
    await fs.promises.unlink(filePath);
  } catch (err) {
    /** Ignore error if file doesn't exist */
    if (err.code !== "ENOENT") {
      console.error("Error occurred while deleting the file:", err);
      // throw err;
    }
  }

  /** Generate the iCal data */
  const iCalData = cal.toString();

  /** Save the iCal data to a file */
  try {
    await fs.promises.writeFile(filePath, iCalData, "utf-8");
    console.log("iCalendar file generated successfully.");
    return { fileName, filePath: `/calendar/${fileName}` };
  } catch (err) {
    console.error("Error occurred while writing iCalendar file:", err);
    // throw err;
  }
}
