import axios from "axios";
import db from "../db-config.js";
import { storeError, settingObj, getRecord } from "./general.js";
import { sendResponse } from "./wrapper.js";

async function trackUserActivity(sessionEmail, moduleId) {
  try {
    const response = await axios.post("http://192.168.1.53:3005/api/client-sessions", {
      sessionEmail,
      moduleId,
    });

    // console.log(response.data);
  } catch (error) {
    console.error("Error tracking session:", error);
  }
}

// export const sideBarPermissionCheck =
//   (accessType, moduleId, tableName, field = "organization") =>
//   async (req, res, next) => {
//     try {
//       const { body, params } = req;
//       if (accessType == "view") {
//         if (tableName) {
//           // console.log(tableName);
//           const [check] = await db.query(
//             `SELECT table_name FROM sidebar WHERE id = ${moduleId}`
//           );
//           if (!check[0].table_name) {
//             await db.query(
//               `UPDATE sidebar SET table_name = ? WHERE id = ? AND table_name IS NULL`,
//               [tableName, moduleId]
//             );
//           }
//         }
//       }

//       /**Fetch all permission of login user */
//       const [permissionsData] = await db.query(
//         `SELECT permission , organization FROM users WHERE id = ${req.user.sessionid}`
//       );
//       const userOrganizations = JSON.parse(permissionsData[0].organization);
//       const permissions = JSON.parse(permissionsData[0].permission);
//       if (permissions?.length === 0 || !permissions?.length) {
//         return res.status(401).json({
//           status: false,
//           message: "You don't have permission",
//         });
//       }
//         let sidebarExistsCheck = false;
//       for (let i = 0; i < permissions?.length; i++) {
//         if (permissions[i].sidebarId == moduleId) {
//           sidebarExistsCheck = true;
//           if (accessType == "delete" || accessType == "edit") {
//             const id = accessType == "delete" ? params.id : body.id;
//             if (!id) {
//               throw new Error("Id is required");
//             }
//             delete req.body.updated_at;
//             // console.log(req.body.updated_at, "updated_at")
//             const [findOrganization] = await db.query(
//               `SELECT ${field} as organization FROM ${tableName} WHERE id = '${id}'`
//             );
//             // console.log(
//             // `SELECT ${field} as organization FROM ${tableName} WHERE id = ${id}`
//             // );
//             // console.log("organization query result", findOrganization);
//             const organization = +findOrganization[0]?.organization;
//             // console.log("organization", organization);
//             let editedOrganization = organization;
//             if (!Array.isArray(body.organization) && body.organization) {
//               editedOrganization = body.organization;
//             }
//             // console.log("editedOrganization", editedOrganization);
//             // console.log( permissions[i]?.permissions[organization][accessType], "permissions[i]?.permissions[organization]", accessType);

//             if (
//               permissions[i]?.permissions &&
//               permissions[i]?.permissions[organization] &&
//               permissions[i]?.permissions[organization][accessType] &&
//               (settingObj[tableName] ||
//                 (permissions[i]?.permissions[editedOrganization] &&
//                   permissions[i]?.permissions[editedOrganization][accessType]))
//             ) {
//               next();
//             } else {
//               return res.status(401).json({
//                 status: false,
//                 message: `You don't have permission to ${accessType} record of organization ${organization} for moduleId ${moduleId}`,
//               });
//             }
//           } else if (accessType == "view") {
//             const additionalData = [];
//             let permissionObj = permissions[i]?.permissions;
//             for (let key in permissionObj) {
//               if (permissionObj[key] && permissionObj[key][accessType]) {
//                 additionalData.push(key);
//               }
//             }
//             req.additionalData = additionalData;
//             req.user.additionalData = additionalData;
//             // return console.log(additionalData);
//             next();
//           } else if (accessType == "create") {

//             const [check] = await db.query(
//               `SELECT  path FROM sidebar WHERE id = ${moduleId}`
//             );
//             // console.log(check)

//             if (!check[0]?.path.includes("/settings")) {
//               if (!req.body?.organization && !req.body?.department) {
//                 return res.status(401).json({
//                   status: false,
//                   message: "Either organization or department is required",
//                 });
//               }
//             }

//             let organizationArray = [];
//             if (
//               req.body?.organization?.length > 0 &&
//               Array.isArray(req.body.organization)
//             ) {
//               let accessedOrganization = [];
//               let permissionObj = permissions[i].permissions;
//               for (let element of req.body.organization) {
//                 if (
//                   permissionObj[element] &&
//                   permissionObj[element][accessType]
//                 ) {
//                   accessedOrganization.push(element);
//                 }
//               }
//               req.body.organization = accessedOrganization;
//               organizationArray = accessedOrganization;
//             } else if (req.body.organization > 0) {
//               organizationArray.push(req.body.organization);
//             } else {
//               let accessedOrganization = [];
//               let permissionObj = permissions[i]?.permissions;
//               for (let key in permissionObj) {
//                 if (permissionObj[key] && permissionObj[key][accessType]) {
//                   accessedOrganization.push(key);
//                 }
//               }
//               req.body.organization = accessedOrganization;
//               organizationArray = accessedOrganization;
//             }
//             // last check if organization length is 0 then return from here have'nt access
//             if (organizationArray.length === 0) {
//               return res.status(401).json({
//                 status: false,
//                 message: "You don't have permission to access this",
//               });
//             }
//             next();
//           } else {
//             return res.status(401).json({
//               status: false,
//               message:
//                 "You don't have permission to access this access Type not found",
//             });
//           }
//         }
//       }
//        if(!sidebarExistsCheck){
//         const [sideBarRecord] = await db.query(`SELECT * FROM sidebar WHERE id = ?`, [moduleId]);
//          return sendResponse(res , 401, `You don't have permission to access ${sideBarRecord[0]?.title} module moduleId: ${moduleId} or module is deleted`);
//        }
//         if(permissions?.length === 0 || !permissions?.length){
//           return sendResponse(res, 401, "You don't have permission to access this module make access request to admin");
//         }
//     } catch (error) {
//       // Check if an error occurs, then send that error to the log file
//       storeError(error);
//       return res.status(500).json({
//         status: false,
//         message: error.message,
//       });
//     }
//   };

export const sideBarPermissionCheck =
  (accessType, moduleId, tableName, field = "organization") =>
  async (req, res, next) => {
    try {
      const { body, params } = req;
      if (accessType == "view") {
        if (tableName) {
          const [check] = await db.query(`SELECT table_name FROM sidebar WHERE id = ${moduleId}`);
          if (!check[0].table_name) {
            await db.query(`UPDATE sidebar SET table_name = ? WHERE id = ? AND table_name IS NULL`, [
              tableName,
              moduleId,
            ]);
          }
        }
      }

      /** Fetch all permission of login user */
      const [permissionsData] = await db.query(
        `SELECT permission, organization FROM users WHERE id = ${req.user.sessionid}`
      );
      const userOrganizations = JSON.parse(permissionsData[0].organization);
      const permissions = JSON.parse(permissionsData[0].permission);
      // console.log('permissions: ', permissions);
      if (permissions?.length === 0 || !permissions?.length) {
        return res.status(401).json({
          status: false,
          message: "You don't have permission",
        });
      }
      const [check] = await db.query(`SELECT path FROM sidebar WHERE id = ${moduleId}`);
      if (
        !check[0]?.path.includes("/settings/department") &&
        !check[0]?.path.includes("/settings/teams") &&
        check[0]?.path.includes("/settings")
      ) {
        req.user.settings = true;
      }
      let sidebarExistsCheck = false;
      for (let i = 0; i < permissions?.length; i++) {
        if (permissions[i].sidebarId == moduleId) {
          sidebarExistsCheck = true;
          if (accessType == "delete" || accessType == "edit") {
            const id = accessType == "delete" ? params.id : body.id;
            if (!id) {
              throw new Error("Id is required");
            }
            delete req.body.updated_at;

            const [findOrganization] = await db.query(
              `SELECT ${field} as organization FROM ${tableName} WHERE id = '${id}'`
            );

            let organizationIds = findOrganization[0]?.organization;
            if (typeof organizationIds === "string") {
              organizationIds = JSON.parse(organizationIds);
            }
            if (!Array.isArray(organizationIds)) {
              organizationIds = [organizationIds];
            }

            let hasPermission = organizationIds.some((orgId) => permissions[i]?.permissions?.[orgId]?.[accessType]);

            if (hasPermission) {
              // trackUserActivity(req.user.sessionEmail, moduleId);
              next();
            } else {
              return res.status(401).json({
                status: false,
                message: `You don't have permission to ${accessType} record of organization ${organizationIds} for moduleId ${moduleId}`,
              });
            }
          } else if (accessType == "view") {
            const additionalData = [];
            let permissionObj = permissions[i]?.permissions;
            for (let key in permissionObj) {
              if (permissionObj[key] && permissionObj[key][accessType]) {
                additionalData.push(key);
              }
            }
            req.additionalData = additionalData;
            req.user.additionalData = additionalData;
            // trackUserActivity(req.user.sessionEmail, moduleId);
            next();
          } else if (accessType == "create") {
            const [check] = await db.query(`SELECT path FROM sidebar WHERE id = ${moduleId}`);
            if (!check[0]?.path.includes("/settings")) {
              if (!req.body?.organization && !req.body?.department) {
                return res.status(401).json({
                  status: false,
                  message: "Either organization or department is required",
                });
              }
            }

            let organizationArray = [];
            if (req.body?.organization?.length > 0 && Array.isArray(req.body.organization)) {
              organizationArray = req.body.organization.filter(
                (orgId) => permissions[i]?.permissions?.[orgId]?.[accessType]
              );
            } else if (req.body.organization > 0) {
              organizationArray.push(parseInt(req.body.organization));
            } else {
              for (let key in permissions[i]?.permissions) {
                if (permissions[i].permissions[key]?.[accessType]) {
                  organizationArray.push(parseInt(key));
                }
              }
            }

            if (organizationArray.length === 0) {
              return res.status(401).json({
                status: false,
                message: "You don't have permission to access this",
              });
            }
            req.body.organization = parseInt(req.body?.organization) ? req.body?.organization : organizationArray;
            // trackUserActivity(req.user.sessionEmail, moduleId);
            next();
          } else {
            return res.status(401).json({
              status: false,
              message: "You don't have permission to access this access Type not found",
            });
          }
        }
      }

      if (!sidebarExistsCheck) {
        const [sideBarRecord] = await db.query(`SELECT * FROM sidebar WHERE id = ?`, [moduleId]);
        return sendResponse(
          res,
          401,
          `You don't have permission to access ${sideBarRecord[0]?.title} module moduleId: ${moduleId} or module is deleted`
        );
      }

      if (permissions?.length === 0 || !permissions?.length) {
        return sendResponse(res, 401, "You don't have permission to access this module make access request to admin");
      }
    } catch (error) {
      storeError(error);
      return res.status(500).json({
        status: false,
        message: error.message,
      });
    }
  };
