import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { viewActivityLog } from "../controller/ActivityLogController.js";


/**
 * @swagger
 * tags:
 *   name:  activity log
 *   description: API operations for managing  activity log
 */
const activityLogRoutes = Router();

/**
 * @swagger
 * /api/activityLog/get-activity-log:
 *   get:
 *     summary: Get all records of  activity log
 *     tags: [ activity log]
 */
activityLogRoutes.get(
    "/get-activity-log",
    verifyToken,
    // sideBarPermissionCheck("view", 383, "activity_log"),
    controllerWrapper(viewActivityLog)
);

export default activityLogRoutes;