import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateAuditType,
  deleteAuditType,
  viewAuditType,
} from "../controller/auditTypeController.js";

/**
 * @swagger
 * tags:
 *   name:  audit type
 *   description: API operations for managing  audit type
 */
const auditTypeRoutes = Router();

/**
 * @swagger
 * /api/auditType/create-update-audit-type:
 *   post:
 *     summary: Create or update a  audit type
 *     tags: [ audit type]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
auditTypeRoutes.post(
  "/create-update-audit-type",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 383, "audit_type")(
      req,
      res,
      next
    );
  },
  controllerWrapper(createUpdateAuditType)
);

/**
 * @swagger
 * /api/auditType/get-audit-type:
 *   get:
 *     summary: Get all records of  audit type
 *     tags: [ audit type]
 */
auditTypeRoutes.get(
  "/get-audit-type",
  verifyToken,
  sideBarPermissionCheck("view", 383, "audit_type"),
  controllerWrapper(viewAuditType)
);

/**
 * @swagger
 * /api/auditType/get-audit-type/{id}:
 *   get:
 *     summary: Get a specific record of  audit type
 *     tags: [ audit type]
 */
auditTypeRoutes.get(
  "/get-audit-type/:id",
  verifyToken,
  sideBarPermissionCheck("view", 383, "audit_type"),
  controllerWrapper(viewAuditType)
);

/**
 * @swagger
 * /api/auditType/delete-audit-type/{id}:
 *   delete:
 *     summary: Delete a specific record of  audit type
 *     tags: [ audit type]
 */
auditTypeRoutes.delete(
  "/delete-audit-type/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 383, "audit_type"),
  controllerWrapper(deleteAuditType)
);

export default auditTypeRoutes;
