import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateCurrency, deleteCurrency, viewCurrency } from "../controller/currencyController.js";

/**
 * @swagger
 * tags:
 *   name:  currency
 *   description: API operations for managing  currency
 */
const currencyRoutes = Router();

/**
 * @swagger
 * /api/currency/create-update-currency:
 *   post:
 *     summary: Create or update a  currency
 *     tags: [ currency]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
currencyRoutes.post(
  "/create-update-currency",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 384 , "currency")(req, res, next);
  },
  controllerWrapper(createUpdateCurrency)
);

/**
 * @swagger
 * /api/currency/get-currency:
 *   get:
 *     summary: Get all records of  currency
 *     tags: [ currency]
 */
currencyRoutes.get(
  "/get-currency",
  verifyToken,
  sideBarPermissionCheck("view", 384, "currency"),
  controllerWrapper(viewCurrency)
);

/**
 * @swagger
 * /api/currency/get-currency/{id}:
 *   get:
 *     summary: Get a specific record of  currency
 *     tags: [ currency]
 */
currencyRoutes.get(
  "/get-currency/:id",
  verifyToken,
  sideBarPermissionCheck("view", 384, "currency"),
  controllerWrapper(viewCurrency)
);

/**
 * @swagger
 * /api/currency/delete-currency/{id}:
 *   delete:
 *     summary: Delete a specific record of  currency
 *     tags: [ currency]
 */
currencyRoutes.delete(
  "/delete-currency/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 384, "currency"),
  controllerWrapper(deleteCurrency)
);

export default currencyRoutes;