// Import necessary modules
import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { objectiveAndTargetExcel } from "../helper/ObjectiveAndTargetExcel.js";
import { getObjectivesAndTargetRegisterExcel } from "../helper/ObjectivesAndTargetRegisterExcel.js";
import { getOperationalRiskAssessmentRegisterExcel } from "../helper/operationalRiskAssesmentExcel.js";
import { getStrategicRiskAssessmentRegisterExcel } from "../helper/strategicRiskAssesmentRegisterExcel.js";
import { getTacticalRiskAssessmentRegisterExcel } from "../helper/tacticalRiskAssesmentRegisterExcel.js";
import { getContractorAssessmentRegisterExcel } from "../helper/contractorRiskAssessmentExcel.js";

/**
 * @swagger
 * tags:
 *   name: Excel Routes
 *   description: API operations for managing all Excel Download
 */
const excelRoutes = Router();

/**
 * @swagger
 *api/excel/objective-and-target-excel/{id}:
 *   get:
 *     summary: Get the excel file path of Objective and Target Excel for a specific id after file creation
 *     tags: [Excel Routes]
 */

excelRoutes.get(
  "/objective-and-target-excel/:id",
  verifyToken,
  objectiveAndTargetExcel
);

/**
 * @swagger
 *api/excel/objective-and-target-register-excel:
 *   get:
 *     summary: Get the excel file path of Objective and Target Excel after file creation
 *     tags: [Excel Routes]
 */

excelRoutes.get(
  "/objective-and-target-register-excel",
  verifyToken,
  getObjectivesAndTargetRegisterExcel
);

/**
 * @swagger
 *api/excel/strategic-risk-register-excel:
 *   get:
 *     summary: Get the excel file path of Strategic Risk Assessment Register Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.post(
  "/strategic-risk-register-excel",
  verifyToken,
  getStrategicRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/strategic-risk-identification-excel/{id}:
 *   get:
 *     summary: Get the excel file path of Strategic Risk Assessment Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.get(
  "/strategic-risk-identification-excel/:id",
  verifyToken,
  getStrategicRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/tactical-risk-register-excel/{id}:
 *   get:
 *     summary: Get the excel file path of Tactical Risk Assessment Register Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.post(
  "/tactical-risk-register-excel/:id",
  verifyToken,
  getTacticalRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/tactical-risk-identification-excel/{id}:
 *   get:
 *     summary: Get the excel file path of Tactical Risk Assessment Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.get(
  "/tactical-risk-identification-excel/:id",
  verifyToken,
  getTacticalRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/operational-risk-identification-excel/{id}:
 *   get:
 *     summary: Get the excel file path of Operational Risk Identification Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.post(
  "/operational-risk-identification-excel/:id",
  verifyToken,
  getOperationalRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/objective-and-target-excel/{id}:
 *   get:
 *     summary: Get the excel file path of Objective and Target Excel for a specific id after file creation
 *     tags: [Excel Routes]
 */

excelRoutes.get(
  "/objective-and-target-excel/:id",
  verifyToken,
  objectiveAndTargetExcel
);

/**
 * @swagger
 *api/excel/objective-and-target-excel:
 *   get:
 *     summary: Get the excel file path of Objective and Target Excel after file creation
 *     tags: [Excel Routes]
 */

excelRoutes.get(
  "/objective-and-target-register-excel",
  verifyToken,
  getObjectivesAndTargetRegisterExcel
);

/**
 * @swagger
 *api/excel/strategic-risk-register-excel:
 *   get:
 *     summary: Get the excel file path of Strategic Risk Assessment Register Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.post(
  "/strategic-risk-register-excel",
  verifyToken,
  getStrategicRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/strategic-risk-identification-excel:
 *   get:
 *     summary: Get the excel file path of Strategic Risk Assessment Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.get(
  "/strategic-risk-identification-excel",
  verifyToken,
  getStrategicRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/tactical-risk-register-excel:
 *   get:
 *     summary: Get the excel file path of Tactical Risk Assessment Register Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.post(
  "/tactical-risk-register-excel",
  verifyToken,
  getTacticalRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/tactical-risk-identification-excel:
 *   get:
 *     summary: Get the excel file path of Tactical Risk Assessment Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.get(
  "/tactical-risk-identification-excel",
  verifyToken,
  getTacticalRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/operational-risk-identification-excel:
 *   get:
 *     summary: Get the excel file path of Operational Risk Identification Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.post(
  "/operational-risk-identification-excel",
  verifyToken,
  getOperationalRiskAssessmentRegisterExcel
);

/**
 * @swagger
 *api/excel/contractor-risk-register-excel/{id}:
 *   get:
 *     summary: Get the excel file path of Contractor Risk Register Excel after creation
 *     tags: [Excel Routes]
 */

excelRoutes.post(
  "/contractor-risk-register-excel/:id",
  verifyToken,
  getContractorAssessmentRegisterExcel
);
excelRoutes.post(
  "/contractor-risk-register-excel",
  verifyToken,
  getContractorAssessmentRegisterExcel
);

export default excelRoutes;
