import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateFileClassification, deleteFileClassification, viewFileClassification } from "../controller/fileClassificationController.js";

/**
 * @swagger
 * tags:
 *   name:  file classification
 *   description: API operations for managing  file classification
 */
const fileClassificationRoutes = Router();

/**
 * @swagger
 * /api/fileClassification/create-update-file-classification:
 *   post:
 *     summary: Create or update a  file classification
 *     tags: [ file classification]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
fileClassificationRoutes.post(
  "/create-update-file-classification",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 388 , "file_classification")(req, res, next);
  },
  controllerWrapper(createUpdateFileClassification)
);

/**
 * @swagger
 * /api/fileClassification/get-file-classification:
 *   get:
 *     summary: Get all records of  file classification
 *     tags: [ file classification]
 */
fileClassificationRoutes.get(
  "/get-file-classification",
  verifyToken,
  sideBarPermissionCheck("view", 388, "file_classification"),
  controllerWrapper(viewFileClassification)
);

/**
 * @swagger
 * /api/fileClassification/get-file-classification/{id}:
 *   get:
 *     summary: Get a specific record of  file classification
 *     tags: [ file classification]
 */
fileClassificationRoutes.get(
  "/get-file-classification/:id",
  verifyToken,
  sideBarPermissionCheck("view", 388, "file_classification"),
  controllerWrapper(viewFileClassification)
);

/**
 * @swagger
 * /api/fileClassification/delete-file-classification/{id}:
 *   delete:
 *     summary: Delete a specific record of  file classification
 *     tags: [ file classification]
 */
fileClassificationRoutes.delete(
  "/delete-file-classification/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 388, "file_classification"),
  controllerWrapper(deleteFileClassification)
);

export default fileClassificationRoutes;