import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateIncidentLocation,
  deleteIncidentLocation,
  getParentIncidentLocationList,
  viewIncidentLocation,
  viewIncidentLocationDropdown,
} from "../controller/incidentLocationController.js";

/**
 * @swagger
 * tags:
 *   name:  incident location
 *   description: API operations for managing  incident location
 */
const incidentPpeRoutes = Router();

/**
 * @swagger
 * /api/incidentPpe/create-update-incident-location:
 *   post:
 *     summary: Create or update a  incident location
 *     tags: [ incident location]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
incidentPpeRoutes.post(
  "/create-update-incident-location",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 404, "incident_location")(req, res, next);
  },
  controllerWrapper(createUpdateIncidentLocation)
);

/**
 * @swagger
 * /api/incidentPpe/get-incident-location:
 *   get:
 *     summary: Get all records of  incident location
 *     tags: [ incident location]
 */
incidentPpeRoutes.get(
  "/get-incident-location",
  verifyToken,
  sideBarPermissionCheck("view", 404, "incident_location"),
  controllerWrapper(viewIncidentLocation)
);
/**
 * @swagger
 * /api/incidentPpe/get-incident-location-dropdown:
 *   get:
 *     summary: Get all records of  incident location
 *     tags: [ incident location]
 */
incidentPpeRoutes.get(
  "/get-incident-location-dropdown",
  verifyToken,
  // sideBarPermissionCheck("view", 404, "incident_location"),
  controllerWrapper(viewIncidentLocationDropdown)
);

/**
 * @swagger
 * /api/incidentPpe/get-incident-location/{id}:
 *   get:
 *     summary: Get a specific record of  incident location
 *     tags: [ incident location]
 */
incidentPpeRoutes.get(
  "/get-incident-location/:id",
  verifyToken,
  sideBarPermissionCheck("view", 404, "incident_location"),
  controllerWrapper(viewIncidentLocation)
);

/**
 * @swagger
 * /api/incidentPpe/get-incident-location-list:
 *   get:
 *     summary: Get the list for selecting parent category
 *     tags: [ incident location]
 *     parameters:
 *       - in: query
 *         organization : [1,2,34,4]
 *         schema:
 *           type: Array
 *         description: Array of organization to fetch the list
 */

incidentPpeRoutes.get("/get-incident-location-list", verifyToken, controllerWrapper(getParentIncidentLocationList));

/**
 * @swagger
 * /api/incidentPpe/delete-incident-location/{id}:
 *   delete:
 *     summary: Delete a specific record of  incident location
 *     tags: [ incident location]
 */
incidentPpeRoutes.delete(
  "/delete-incident-location/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 404, "incident_location"),
  controllerWrapper(deleteIncidentLocation)
);

export default incidentPpeRoutes;
