import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdatePurposeOfTraining, deletePurposeOfTraining, viewPurposeOfTraining } from "../controller/purposeOfTrainingController.js";

/**
 * @swagger
 * tags:
 *   name:  purpose of training
 *   description: API operations for managing  purpose of training
 */
const purposeOfTrainingRoutes = Router();

/**
 * @swagger
 * /api/purposeOfTraining/create-update-purpose-of-training:
 *   post:
 *     summary: Create or update a  purpose of training
 *     tags: [ purpose of training]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
purposeOfTrainingRoutes.post(
  "/create-update-purpose-of-training",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 382 , "purpose_of_training")(req, res, next);
  },
  controllerWrapper(createUpdatePurposeOfTraining)
);

/**
 * @swagger
 * /api/purposeOfTraining/get-purpose-of-training:
 *   get:
 *     summary: Get all records of  purpose of training
 *     tags: [ purpose of training]
 */
purposeOfTrainingRoutes.get(
  "/get-purpose-of-training",
  verifyToken,
  sideBarPermissionCheck("view", 382, "purpose_of_training"),
  controllerWrapper(viewPurposeOfTraining)
);

/**
 * @swagger
 * /api/purposeOfTraining/get-purpose-of-training/{id}:
 *   get:
 *     summary: Get a specific record of  purpose of training
 *     tags: [ purpose of training]
 */
purposeOfTrainingRoutes.get(
  "/get-purpose-of-training/:id",
  verifyToken,
  sideBarPermissionCheck("view", 382, "purpose_of_training"),
  controllerWrapper(viewPurposeOfTraining)
);

/**
 * @swagger
 * /api/purposeOfTraining/delete-purpose-of-training/{id}:
 *   delete:
 *     summary: Delete a specific record of  purpose of training
 *     tags: [ purpose of training]
 */
purposeOfTrainingRoutes.delete(
  "/delete-purpose-of-training/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 382, "purpose_of_training"),
  controllerWrapper(deletePurposeOfTraining)
);

export default purposeOfTrainingRoutes;