import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateRace, deleteRace, viewRace } from "../controller/raceController.js";

/**
 * @swagger
 * tags:
 *   name:  race
 *   description: API operations for managing  race
 */
const raceRoutes = Router();

/**
 * @swagger
 * /api/race/create-update-race:
 *   post:
 *     summary: Create or update a  race
 *     tags: [ race]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
raceRoutes.post(
  "/create-update-race",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 452 , "race")(req, res, next);
  },
  controllerWrapper(createUpdateRace)
);

/**
 * @swagger
 * /api/race/get-race:
 *   get:
 *     summary: Get all records of  race
 *     tags: [ race]
 */
raceRoutes.get(
  "/get-race",
  verifyToken,
  sideBarPermissionCheck("view", 452, "race"),
  controllerWrapper(viewRace)
);

/**
 * @swagger
 * /api/race/get-race/{id}:
 *   get:
 *     summary: Get a specific record of  race
 *     tags: [ race]
 */
raceRoutes.get(
  "/get-race/:id",
  verifyToken,
  sideBarPermissionCheck("view", 452, "race"),
  controllerWrapper(viewRace)
);

/**
 * @swagger
 * /api/race/delete-race/{id}:
 *   delete:
 *     summary: Delete a specific record of  race
 *     tags: [ race]
 */
raceRoutes.delete(
  "/delete-race/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 452, "race"),
  controllerWrapper(deleteRace)
);

export default raceRoutes;