import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateReasonForInactive, deleteReasonForInactive, viewReasonForInactive } from "../controller/reasonForInactiveController.js";

/**
 * @swagger
 * tags:
 *   name:  reason for inactive
 *   description: API operations for managing  reason for inactive
 */
const reasonForInactiveRoutes = Router();

/**
 * @swagger
 * /api/reasonForInactive/create-update-reason-for-inactive:
 *   post:
 *     summary: Create or update a  reason for inactive
 *     tags: [ reason for inactive]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
reasonForInactiveRoutes.post(
  "/create-update-reason-for-inactive",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 374 , "reason_for_inactive")(req, res, next);
  },
  controllerWrapper(createUpdateReasonForInactive)
);

/**
 * @swagger
 * /api/reasonForInactive/get-reason-for-inactive:
 *   get:
 *     summary: Get all records of  reason for inactive
 *     tags: [ reason for inactive]
 */
reasonForInactiveRoutes.get(
  "/get-reason-for-inactive",
  verifyToken,
  sideBarPermissionCheck("view", 374, "reason_for_inactive"),
  controllerWrapper(viewReasonForInactive)
);

/**
 * @swagger
 * /api/reasonForInactive/get-reason-for-inactive/{id}:
 *   get:
 *     summary: Get a specific record of  reason for inactive
 *     tags: [ reason for inactive]
 */
reasonForInactiveRoutes.get(
  "/get-reason-for-inactive/:id",
  verifyToken,
  sideBarPermissionCheck("view", 374, "reason_for_inactive"),
  controllerWrapper(viewReasonForInactive)
);

/**
 * @swagger
 * /api/reasonForInactive/delete-reason-for-inactive/{id}:
 *   delete:
 *     summary: Delete a specific record of  reason for inactive
 *     tags: [ reason for inactive]
 */
reasonForInactiveRoutes.delete(
  "/delete-reason-for-inactive/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 374, "reason_for_inactive"),
  controllerWrapper(deleteReasonForInactive)
);

export default reasonForInactiveRoutes;