import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import { createUpdateSopCategory, deleteSopCategory, viewSopCategory } from "../controller/sopCategoryController.js";

/**
 * @swagger
 * tags:
 *   name:  sop category
 *   description: API operations for managing  sop category
 */
const sopCategoryRoutes = Router();

/**
 * @swagger
 * /api/sopCategory/create-update-sop-category:
 *   post:
 *     summary: Create or update a  sop category
 *     tags: [ sop category]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
sopCategoryRoutes.post(
  "/create-update-sop-category",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 441 , "sop_category")(req, res, next);
  },
  controllerWrapper(createUpdateSopCategory)
);

/**
 * @swagger
 * /api/sopCategory/get-sop-category:
 *   get:
 *     summary: Get all records of  sop category
 *     tags: [ sop category]
 */
sopCategoryRoutes.get(
  "/get-sop-category",
  verifyToken,
  sideBarPermissionCheck("view", 441, "sop_category"),
  controllerWrapper(viewSopCategory)
);

/**
 * @swagger
 * /api/sopCategory/get-sop-category/{id}:
 *   get:
 *     summary: Get a specific record of  sop category
 *     tags: [ sop category]
 */
sopCategoryRoutes.get(
  "/get-sop-category/:id",
  verifyToken,
  sideBarPermissionCheck("view", 441, "sop_category"),
  controllerWrapper(viewSopCategory)
);

/**
 * @swagger
 * /api/sopCategory/delete-sop-category/{id}:
 *   delete:
 *     summary: Delete a specific record of  sop category
 *     tags: [ sop category]
 */
sopCategoryRoutes.delete(
  "/delete-sop-category/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 441, "sop_category"),
  controllerWrapper(deleteSopCategory)
);

export default sopCategoryRoutes;