import { Router } from "express";
import { verifyToken } from "../helper/tokenVerify.js";
import { controllerWrapper } from "../helper/wrapper.js";
import { sideBarPermissionCheck } from "../helper/checkPermission.js";
import {
  createUpdateTypeOfService,
  deleteTypeOfService,
  viewServiceType,
  viewTypeOfService,
} from "../controller/typeOfServiceController.js";

/**
 * @swagger
 * tags:
 *   name:  type of service
 *   description: API operations for managing  type of service
 */
const typeOfServiceRoutes = Router();

/**
 * @swagger
 * /api/typeOfService/create-update-type-of-service:
 *   post:
 *     summary: Create or update a  type of service
 *     tags: [ type of service]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           example: { id: "id", title: "title", description: "description" }
 */
typeOfServiceRoutes.post(
  "/create-update-type-of-service",
  verifyToken,
  (req, res, next) => {
    sideBarPermissionCheck(req.body.id ? "edit" : "create", 385, "type_of_service")(req, res, next);
  },
  controllerWrapper(createUpdateTypeOfService)
);

/**
 * @swagger
 * /api/typeOfService/get-type-of-service:
 *   get:
 *     summary: Get all records of  type of service
 *     tags: [ type of service]
 */
typeOfServiceRoutes.get(
  "/get-type-of-service",
  verifyToken,
  sideBarPermissionCheck("view", 385, "type_of_service"),
  controllerWrapper(viewTypeOfService)
);
/**
 * @swagger
 * /api/typeOfService/get-service-type:
 *   get:
 *     summary: Get all records of  type of service
 *     tags: [ type of service]
 */
typeOfServiceRoutes.get(
  "/get-service-type",
  verifyToken,
  sideBarPermissionCheck("view", 385, "type_of_service"),
  controllerWrapper(viewServiceType)
);

/**
 * @swagger
 * /api/typeOfService/get-type-of-service/{id}:
 *   get:
 *     summary: Get a specific record of  type of service
 *     tags: [ type of service]
 */
typeOfServiceRoutes.get(
  "/get-type-of-service/:id",
  verifyToken,
  sideBarPermissionCheck("view", 385, "type_of_service"),
  controllerWrapper(viewTypeOfService)
);

/**
 * @swagger
 * /api/typeOfService/delete-type-of-service/{id}:
 *   delete:
 *     summary: Delete a specific record of  type of service
 *     tags: [ type of service]
 */
typeOfServiceRoutes.delete(
  "/delete-type-of-service/:id",
  verifyToken,
  sideBarPermissionCheck("delete", 385, "type_of_service"),
  controllerWrapper(deleteTypeOfService)
);

export default typeOfServiceRoutes;
