import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import Repository from "./RepositorySchema.js";

const ContractorAgreements = sequelize.define(
  "ContractorAgreements",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    status: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    form: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    public_url: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    signing_method: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "Digital",
    },
    // document: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
      //onUpdate: "CASCADE",
    },
    total: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    responses: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "contractor_agreements",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorAgreements.belongsTo(ContractorRegistration, {
  as: "contractorDetails",
  foreignKey: "contractor",
});
ContractorAgreements.belongsTo(ProjectRegistration, {
  as: "projectDetails",
  foreignKey: "project",
});
ContractorAgreements.belongsTo(Organization, {
  as: "organizationDetails",
  foreignKey: "organization",
});
ContractorAgreements.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});
ContractorAgreements.belongsTo(User, {
  as: "creator",
  foreignKey: "created_by",
});
ContractorAgreements.belongsTo(User, {
  as: "updater",
  foreignKey: "updated_by",
});

// console.log(await ContractorAgreements.sync({ alter: true }));

export default ContractorAgreements;
