import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import ContractorAppointment from "./ContractorAppointmentSchema.js";

const ContractorAppointmentDocs = sequelize.define(
  "ContractorAppointmentDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    contractor_appointment_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorAppointment,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "contractor_appointment_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
ContractorAppointmentDocs.belongsTo(ContractorAppointment, {
  as: "appointment",
  foreignKey: "contractor_appointment_id",
});

export default ContractorAppointmentDocs;
