import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import User from "./UserSchema.js";
import AppointmentType from "./AppointmentTypeSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import PhysicalLocation from "./PhysicalLocationSchema.js";
import Repository from "./RepositorySchema.js";
import Location from "./LocationSchema.js";

const ContractorAppointment = sequelize.define(
  "ContractorAppointment",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    signature_type: {
      type: DataTypes.ENUM("Electronic", "Manual"),
      allowNull: false,
      defaultValue: "Manual",
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    appointment_type_appoints: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 1,
    },
    appoints_user_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },

    physical_location: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Location,
        key: "id",
      },
    },
    appointed_user: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    appointed_email: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    appointed_role_name: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    name_of_appointment: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: AppointmentType,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    effective_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    end_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "contractor_appointments",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorAppointment.belongsTo(ContractorRegistration, {
  as: "contractorDetails",
  foreignKey: "contractor",
});

ContractorAppointment.belongsTo(User, {
  as: "appointingUser",
  foreignKey: "appoints_user_id",
});

ContractorAppointment.belongsTo(AppointmentType, {
  as: "appointmentType",
  foreignKey: "name_of_appointment",
});

ContractorAppointment.belongsTo(ProjectRegistration, {
  as: "Project",
  foreignKey: "project",
});

ContractorAppointment.belongsTo(Organization, {
  as: "organizationDetails",
  foreignKey: "organization",
});

ContractorAppointment.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});

// console.log(await ContractorAppointment.sync({ alter: true }));

export default ContractorAppointment;
