import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import ContractorAuditScheduling from "./ContractorAuditSchedulingSchema.js";

const ContractorAuditRecord = sequelize.define(
  "ContractorAuditRecord",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    name: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    audit_execution: {
      type: DataTypes.INTEGER,
      allowNull: true,
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    audit_record: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    total_point: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    earned_points: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: null,
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    deleted: {
      type: DataTypes.TINYINT,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "contractor_audit_record",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ContractorAuditRecord.belongsTo(Organization, {
  as: "organizationDetails",
  foreignKey: "organization",
});

ContractorAuditRecord.belongsTo(Department, {
  as: "departmentDetails",
  foreignKey: "department",
});

ContractorAuditRecord.belongsTo(User, {
  as: "createdBy",
  foreignKey: "created_by",
});

ContractorAuditRecord.belongsTo(User, {
  as: "updatedBy",
  foreignKey: "updated_by",
});
// console.log(await ContractorAuditRecord.sync({ alter: true }));

export default ContractorAuditRecord;
