// import { DataTypes } from "sequelize";
// import sequelize from "./sequelize.js"; // Adjust the import path as necessary
// import User from "./UserSchema.js";
// import AuditTemplate from "./AuditTemplateSchema.js";
// import AuditCategory from "./AuditCategorySchema.js";
// import Organization from "./OrganizationSchema.js";
// import Department from "./DepartmentSchema.js";
// import ContractorRegistration from "./ContractorRegistrationSchema.js";
// import ProjectRegistration from "./ProjectRegistrationSchema.js";

// const ContractorAuditScheduling = sequelize.define(
//   "ContractorAuditScheduling",
//   {
//     id: {
//       type: DataTypes.INTEGER,
//       autoIncrement: true,
//       primaryKey: true,
//     },
//     contractor: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//       references: {
//         model: ContractorRegistration,
//         key: "id",
//       },
//       onDelete: "SET NULL",
//       onUpdate: "CASCADE",
//     },
//     project: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//       references: {
//         model: ProjectRegistration,
//         key: "id",
//       },
//       onDelete: "SET NULL",
//       onUpdate: "CASCADE",
//     },
//     audit_name: {
//       type: DataTypes.STRING(250),
//       allowNull: true,
//     },
//     audit_template: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//       references: {
//         model: AuditTemplate,
//         key: "id",
//       },
//       //onUpdate: "CASCADE",
//       //onDelete: "SET NULL",
//     },
//     audit_type: {
//       type: DataTypes.STRING(500),
//       allowNull: true,
//     },
//     recurrence_cycle: {
//       type: DataTypes.BIGINT,
//       allowNull: true,
//     },
//     repeats: {
//       type: DataTypes.STRING(255),
//       allowNull: true,
//     },
//     planned_audit_start_date_time: {
//       type: DataTypes.DATE,
//       allowNull: true,
//     },
//     planned_audit_end_date_time: {
//       type: DataTypes.DATE,
//       allowNull: true,
//     },
//     audit_category: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//       references: {
//         model: AuditCategory,
//         key: "id",
//       },
//       //onUpdate: "CASCADE",
//       //onDelete: "SET NULL",
//     },
//     audit_focus_area: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     auditor: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//       references: {
//         model: ContractorRegistration,
//         key: "id",
//       },
//       //onUpdate: "CASCADE",
//       //onDelete: "SET NULL",
//     },
//     no_of_cycle: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     auditor_lead: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     auditor_members: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     audit_scope: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     location: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     status: {
//       type: DataTypes.STRING(250),
//       allowNull: true,
//     },
//     critical_business_processes: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     allocation_human_resource: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     technological_resources: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     type_of_resources: {
//       type: DataTypes.TEXT("long"),
//       allowNull: true,
//     },
//     amount: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//     },
//     opening_name_of_meeting: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//     },
//     closing_name_of_meeting: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//     },
//     organization: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//       references: {
//         model: Organization,
//         key: "id",
//       },
//       //onUpdate: "CASCADE",
//       //onDelete: "SET NULL",
//     },
//     department: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//       references: {
//         model: Department,
//         key: "id",
//       },
//       //onUpdate: "CASCADE",
//       //onDelete: "SET NULL",
//     },
//     created_at: {
//       type: DataTypes.DATE,
//       allowNull: true,
//       defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
//     },
//     created_by: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//       references: {
//         model: User,
//         key: "id",
//       },
//       //onUpdate: "CASCADE",
//       //onDelete: "SET NULL",
//     },
//     deleted: {
//       type: DataTypes.TINYINT,
//       allowNull: true,
//       defaultValue: 0,
//     },
//     updated_at: {
//       type: DataTypes.DATE,
//       allowNull: true,
//       defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
//       onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
//     },
//     updated_by: {
//       type: DataTypes.INTEGER,
//       allowNull: true,
//       references: {
//         model: User,
//         key: "id",
//       },
//       //onUpdate: "CASCADE",
//       //onDelete: "SET NULL",
//     },
//   },
//   {
//     tableName: "contractor_audit_scheduling",
//     timestamps: false,

//     charset: "utf8mb4",
//     collate: "utf8mb4_general_ci",
//   }
// );

// // Define associations
// ContractorAuditScheduling.belongsTo(AuditTemplate, {
//   as: "auditTemplateDetails",
//   foreignKey: "audit_template",
// });

// ContractorAuditScheduling.belongsTo(AuditCategory, {
//   as: "auditCategoryDetails",
//   foreignKey: "audit_category",
// });

// ContractorAuditScheduling.belongsTo(Organization, {
//   as: "organizationDetails",
//   foreignKey: "organization",
// });

// ContractorAuditScheduling.belongsTo(Department, {
//   as: "departmentDetails",
//   foreignKey: "department",
// });

// ContractorAuditScheduling.belongsTo(User, {
//   as: "createdBy",
//   foreignKey: "created_by",
// });

// ContractorAuditScheduling.belongsTo(User, {
//   as: "updatedBy",
//   foreignKey: "updated_by",
// });

// export default ContractorAuditScheduling;

import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";
import Department from "./DepartmentSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";
import Sidebar from "./SidebarSchema.js";
import Currency from "./CurrencySchema.js";
import { EndFields } from "../constants/constants.js";
import AuditType from "./AuditTypeSchema.js";
import AuditTemplate from "./AuditTemplateSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import Repository from "./RepositorySchema.js";

const scheduleTypeArr = Object.freeze([
  "audit",
  "inspection",
  "monitoring",
  "assessment",
  "surveillance",
  "certifications",
  "testing-examination",
]);
const linkedToArr = Object.freeze([
  "Permits",
  "SOPs",
  "Policy",
  "Action",
  "Incident",
  "NCR",
  "Business Continuity",
]);
const statusArr = Object.freeze(["Todo", "In progress", "Executed", "Overdue"]);
const sourceArr = Object.freeze(["Internal", "External"]);
const participantArr = Object.freeze(["Internal", "External"]);
const evaluationStatusArr = Object.freeze([
  "Applicable",
  "Not Applicable",
  "Added",
  "Not Added",
]);

const ContractorAuditScheduling = sequelize.define(
  "ContractorAuditScheduling",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    name: {
      type: DataTypes.STRING(250),
    },
    contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
      onDelete: "SET NULL",
      onUpdate: "CASCADE",
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      onDelete: "SET NULL",
      onUpdate: "CASCADE",
    },
    type: {
      type: DataTypes.INTEGER,
      references: {
        model: AuditType,
        key: AuditType.primaryKeyAttribute,
      },
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    schedule_type: {
      type: DataTypes.ENUM(scheduleTypeArr),
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    linked_to: {
      type: DataTypes.ENUM(linkedToArr),
    },
    module: {
      type: DataTypes.INTEGER,
      references: {
        model: Sidebar,
        key: Sidebar.primaryKeyAttribute,
      },
    },
    sub_module: {
      type: DataTypes.INTEGER,
      references: {
        model: Sidebar,
        key: "id",
      },
    },
    planned_start_date: {
      type: DataTypes.DATEONLY,
    },
    planned_end_date: {
      type: DataTypes.DATEONLY,
    },
    actual_start_date: {
      type: DataTypes.DATEONLY,
    },
    actual_end_date: {
      type: DataTypes.DATEONLY,
    },
    want_to_repeat: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    source: {
      type: DataTypes.ENUM(sourceArr),
    },
    lead_person: {
      type: DataTypes.TEXT("long"),
    },
    reference_number: {
      type: DataTypes.INTEGER,
    },
    participant_type: {
      type: DataTypes.ENUM(participantArr),
    },
    stakeholder: {
      type: DataTypes.TEXT("long"),
    },
    record_name: {
      type: DataTypes.INTEGER,
    },
    location: {
      type: DataTypes.TEXT("long"),
    },
    repeat_when: {
      type: DataTypes.STRING(255),
    },
    cycles: {
      type: DataTypes.STRING(255),
    },
    members: {
      type: DataTypes.TEXT("long"),
    },
    owner: {
      type: DataTypes.STRING(255),
    },
    participants: {
      type: DataTypes.TEXT("long"),
    },
    scope: {
      type: DataTypes.TEXT("long"),
    },
    critical_business: {
      type: DataTypes.TEXT("long"),
    },
    financial_resource: {
      type: DataTypes.STRING(255),
    },
    operating_budget_value: {
      type: DataTypes.INTEGER,
    },
    operating_budget_currency: {
      type: DataTypes.INTEGER,
      // references: {
      //   model: Currency,
      //   key: "id",
      // },
    },
    capital_budget_value: {
      type: DataTypes.INTEGER,
    },
    capital_budget_currency: {
      type: DataTypes.INTEGER,
      // references: {
      //   model: Currency,
      //   key: "id",
      // },
    },
    audit_record: {
      type: DataTypes.INTEGER,
      references: {
        model: "contractor_audit_record",
        key: "id",
      },
    },
    opening_meeting_agenda: {
      type: DataTypes.TEXT("long"),
    },
    closing_meeting_agenda: {
      type: DataTypes.TEXT("long"),
    },
    evaluation_tool_status: {
      type: DataTypes.ENUM(evaluationStatusArr),
    },
    technological_resources: {
      type: DataTypes.TEXT("long"),
    },
    evaluation_tool: {
      type: DataTypes.INTEGER,
      references: {
        model: AuditTemplate,
        key: AuditTemplate.primaryKeyAttribute,
      },
    },
    status: {
      type: DataTypes.ENUM(statusArr),
      defaultValue: "Todo",
    },
    report: {
      type: DataTypes.STRING(1000),
    },
    ...EndFields,
  },
  {
    tableName: "contractor_audit_scheduling",
    paranoid: true,
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);
// ContractorAuditScheduling.belongsTo(Currency, {
//   foreignKey: {
//     name: "capital_budget_currency_fk", // Custom foreign key name
//     allowNull: true,
//   },
//   targetKey: "id", // Reference key in the Currency model
// });
// ContractorAuditScheduling.belongsTo(Currency, {
//   foreignKey: {
//     name: "operating_budget_currency_fk", // Custom foreign key name
//     allowNull: true,
//   },
//   targetKey: "id", // Reference key in the Currency model
// });

// console.log(await ContractorAuditScheduling.sync({ alter: true }));

export default ContractorAuditScheduling;
