import db from "../db-config.js";
import ContractorForms from "./ContractorFormSchema.js";
import FinalHandover from "./FinalHandoverSchema.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";

const FinalHandoverResponses = sequelize.define(
  "FinalHandoverResponses",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    value: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    contractor_name: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    client_representative: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    area: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    rectification_action: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    representative_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    supervisor_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    contract_representative: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    contract_supervisor: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    date_of_inspection: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    contract_number: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    cipc_registration_number: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    employee_email: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "Response Pending",
    },
    contractor_final_handover_form: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ContractorForms,
        key: "id",
      },
    },
    project: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
    },
    form: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    reciept_date: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    comment: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    // endorsement_date: {
    //   type: DataTypes.DATE,
    //   allowNull: true,
    // },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    final_handover_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: FinalHandover,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "CASCADE",
    },
    from_email: {
      type: DataTypes.INTEGER,
      allowNull: false,
      defaultValue: 0,
    },
  },
  {
    timestamps: false,

    tableName: "final_handover_responses",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await FinalHandoverResponses.sync({ alter: true}));

export default FinalHandoverResponses;
// console.log(await db.query("DROP table final_handover_responses;"));
// console.log(
//   await db.query(`
//     ALTER TABLE \`final_handover_responses\`
//     ADD \`contractor_final_handover_form\` INTEGER,
//     ADD CONSTRAINT \`handover_form_fk\`
//     FOREIGN KEY (\`contractor_final_handover_form\`) REFERENCES \`contractor_forms\` (\`id\`);
//   `)
// );
