import FileClassification from "./FileClassificationSchema.js";
import Incident from "./IncidentSchema.js";
import Repository from "./RepositorySchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";

const IncidentDocs = sequelize.define(
  "IncidentDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    incident_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Incident,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file_classification: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: FileClassification,
        key: "id",
      },
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "incident_docs",
    timestamps: false,

    charset: "utf8mb4",
  }
);

IncidentDocs.belongsTo(Incident, { foreignKey: "incident_id", as: "Incident" });

// console.log(await IncidentDocs.sync({ alter: true }));

export default IncidentDocs;
