import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import Incident from "./IncidentSchema.js";
import Severity from "./SeveritySchema.js";
import User from "./UserSchema.js";

const InjuryOnDuty = sequelize.define(
  "InjuryOnDuty",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    incident_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Incident,
        key: "id",
      },
    },
    incident_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    incident_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    incident_time: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    incident_severity: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    incident_category: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      //example: [1, 2, 3, 4]
    },
    incident_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    incident_location: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    injured_persons: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    technical_form_completed_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    role_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    department: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    date_of_submission: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    notification: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    save_type: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    organization: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    for_contractor: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    deleted: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
  },
  {
    timestamps: false,
    tableName: "injury_on_duty",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

InjuryOnDuty.belongsTo(Incident, { foreignKey: "incident_id", as: "Incident" });
InjuryOnDuty.belongsTo(User, { foreignKey: "created_by", as: "CreatedBy" });
InjuryOnDuty.belongsTo(User, { foreignKey: "updated_by", as: "UpdatedBy" });
// console.log(await InjuryOnDuty.sync({ alter: true }));
export default InjuryOnDuty;
