import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import ObjectiveSetting from "./ObjectiveSettingSchema.js";
import User from "./UserSchema.js";

const ObjectiveSettingTargetPlan = sequelize.define(
  "ObjectiveSettingTargetPlan",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    objective_setting_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ObjectiveSetting,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    action_title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    action_description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    responsible_department: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    responsible_person: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    start_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    due_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    action_progress_description: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    action_progress_status: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "objective_setting_target_plan",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ObjectiveSettingTargetPlan.belongsTo(ObjectiveSetting, {
  foreignKey: "objective_setting_id",
  as: "ObjectiveSetting",
});
ObjectiveSettingTargetPlan.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});
ObjectiveSettingTargetPlan.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
export default ObjectiveSettingTargetPlan;
