import Department from "./DepartmentSchema.js";
import OhsFileRequirement from "./OhsFileRequirementSchema.js";
import Organization from "./OrganizationSchema.js";
import sequelize from "./sequelize.js";
import { DataTypes } from "sequelize";
import User from "./UserSchema.js";
import Repository from "./RepositorySchema.js";

const OhsFileAssessment = sequelize.define(
  "OhsFileAssessment",
  {
    id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      autoIncrement: true,
      primaryKey: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ohs_requirement: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: OhsFileRequirement,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    // name_of_contractor: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // company_registration_no: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // coida_registration_no: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // health_safety_representative: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    // contact_person: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // contact_number: {
    //   type: DataTypes.STRING(100),
    //   allowNull: true,
    // },
    // site_address: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // postal_address: {
    //   type: DataTypes.INTEGER,
    //   allowNull: true,
    // },
    // section_appointment: {
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // activities_rendered: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    // commencement_date: {
    //   type: DataTypes.DATEONLY,
    //   allowNull: true,
    // },
    // completion_date: {
    //   type: DataTypes.DATEONLY,
    //   allowNull: true,
    // },
    // employees_on_site: {
    //   type: DataTypes.STRING(100),
    //   allowNull: true,
    // },
    // female: {
    //   type: DataTypes.BIGINT,
    //   allowNull: true,
    // },
    // male: {
    //   type: DataTypes.BIGINT,
    //   allowNull: true,
    // },
    // people_with_disabilities: {
    //   type: DataTypes.STRING(100),
    //   allowNull: true,
    // },
    form: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    vals: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "Pending",
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    signing_method: {
      type: DataTypes.STRING(255),
      allowNull: true,
      defaultValue: "Digital",
    },
    document: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "ohs_file_assessment",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

OhsFileAssessment.belongsTo(OhsFileRequirement, {
  foreignKey: "ohs_requirement",
  as: "OhsFileRequirement",
});

OhsFileAssessment.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

OhsFileAssessment.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

OhsFileAssessment.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

OhsFileAssessment.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await OhsFileAssessment.sync({ alter: true }));
export default OhsFileAssessment;
