import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import ProjectRegistration from "./ProjectRegistrationSchema.js";
import Repository from "./RepositorySchema.js";

const ProjectRegistrationDocs = sequelize.define(
  "ProjectRegistrationDocs",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    doc_no: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    project_registration_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: ProjectRegistration,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    title: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    file: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    ddrm_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Repository,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
  },
  {
    tableName: "project_registration_docs",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

ProjectRegistrationDocs.belongsTo(ProjectRegistration, {
  foreignKey: "project_registration_id",
  as: "ProjectRegistration",
});
// console.log(await ProjectRegistrationDocs.sync({ alter: true }));

export default ProjectRegistrationDocs;
