import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import { EndFields } from "../constants/constants.js";
import DocumentType from "./DocumentTypeSchema.js";

const RetentionPolicySetting = sequelize.define(
  "retention_policy_setting",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    document_type_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: DocumentType,
        key: "id",
      },
    },
    retention_period: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    auto_archive: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    auto_delete: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    ...EndFields,
  },
  {
    tableName: "retention_policy_setting",
    timestamps: false,
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

// console.log(await RetentionPolicySetting.sync({ alter: true }));

export default RetentionPolicySetting;
