import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";
import RoleHierarchy from "./RoleHierarchySchema.js";
import HighestQualification from "./HighestQualificationSchema.js";

const Role = sequelize.define(
  "Role",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    level: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    description: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    organization: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    responsibilities: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    qualification: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: HighestQualification,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    year_of_experience: {
      type: DataTypes.STRING(500),
      allowNull: true,
    },
    other_requirements: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    select_other_requirements: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    // effective_date: {
    //   type: DataTypes.DATE,
    //   allowNull: true,
    // },
    report_to_role: {
      type: DataTypes.STRING(11),
      allowNull: true,
    },
    // role_accountability: {
    //   type: DataTypes.TEXT("long"),
    //   allowNull: true,
    // },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    hierarchy: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: RoleHierarchy,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    pre_employment: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    post_employment: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    license: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    skills: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    permission: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
      charset: "utf8mb4",
      collate: "utf8mb4_bin",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    tableName: "roles",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

Role.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

Role.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

Role.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

Role.belongsTo(RoleHierarchy, {
  foreignKey: "hierarchy",
  as: "Hierarchy",
});

Role.belongsTo(HighestQualification, {
  foreignKey: "qualification",
  as: "HighestQualification",
});
// console.log(await Role.sync({ alter: true }));
export default Role;
