import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import TrainingAttendance from "./TrainingAttendanceRecordingSchema.js";
import Organization from "./OrganizationSchema.js";
import User from "./UserSchema.js";
import Department from "./DepartmentSchema.js";

export const TrainingCertificate = sequelize.define(
  "TrainingCertificate",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    attendees: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    certificate_issued: {
      type: DataTypes.STRING(10),
      allowNull: true,
    },
    training_program: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: TrainingAttendance,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    // certificate_number:{
    //   type: DataTypes.STRING(255),
    //   allowNull: true,
    // },
    // certificate_expiry_date:{
    //   type: DataTypes.DATEONLY,
    //   allowNull: true,
    // },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
  },
  {
    timestamps: false,

    tableName: "training_certificate",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

TrainingCertificate.belongsTo(TrainingAttendance, {
  foreignKey: "training_program",
  as: "TrainingAttendance",
});

TrainingCertificate.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

TrainingCertificate.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});
// console.log(await TrainingCertificate.sync({ alter: true }));
export default TrainingCertificate;
