import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import User from "./UserSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";

const TrainingEffectivenessOutcome = sequelize.define(
  "TrainingEffectivenessOutcome",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    employee_name: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    surname: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    employee_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    role_name: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    training_awareness: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    training_date: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    training_venue: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    responses: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(255),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Organization,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    department: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: Department,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    created_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,

    tableName: "effectiveness_outcome",
    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

TrainingEffectivenessOutcome.belongsTo(User, {
  foreignKey: "employee_name",
  as: "Employee",
});

TrainingEffectivenessOutcome.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedBy",
});

TrainingEffectivenessOutcome.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedBy",
});

TrainingEffectivenessOutcome.belongsTo(Organization, {
  foreignKey: "organization",
  as: "Organization",
});

TrainingEffectivenessOutcome.belongsTo(Department, {
  foreignKey: "department",
  as: "Department",
});

// console.log(await TrainingEffectivenessOutcome.sync({alter:true}))


export default TrainingEffectivenessOutcome;
