import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js";
import WasteType from "./WasteTypeSchema.js";
import WasteDisposalMethod from "./WasteDisposalMethodSchema.js";
import ContractorRegistration from "./ContractorRegistrationSchema.js";
import Organization from "./OrganizationSchema.js";
import Department from "./DepartmentSchema.js";
import User from "./UserSchema.js";

const WasteManifest = sequelize.define(
  "WasteManifest",
  {
    waste_type: {
      type: DataTypes.INTEGER,
      references: {
        model: WasteType,
        key: "id",
      },
    },
    quantity: {
      type: DataTypes.BIGINT,
    },
    collection_date: {
      type: DataTypes.DATE,
    },
    disposal_date: {
      type: DataTypes.DATE,
    },
    disposable_method: {
      type: DataTypes.INTEGER,
      references: {
        model: WasteDisposalMethod,
        key: "id",
      },
    },
    contractor: {
      type: DataTypes.INTEGER,
      references: {
        model: ContractorRegistration,
        key: "id",
      },
    },
    site: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    reduction_strategy: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    unique_id: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    collection_site: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    disposal_site: {
      type: DataTypes.STRING(250),
      allowNull: true,
    },
    organization: {
      type: DataTypes.INTEGER,
      references: {
        model: Organization,
        key: "id",
      },
    },
    department: {
      type: DataTypes.INTEGER,
      references: {
        model: Department,
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0,
    },
    created_by: {
      type: DataTypes.INTEGER,
      references: {
        model: User,
        key: "id",
      },
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
      onUpdate: sequelize.literal("CURRENT_TIMESTAMP"),
    },
  },
  {
    timestamps: false,
    underscored: true,
    tableName: "waste_manifest",

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

WasteManifest.belongsTo(WasteType, {
  foreignKey: "waste_type",
  as: "waste_type_details",
});

WasteManifest.belongsTo(WasteDisposalMethod, {
  foreignKey: "disposable_method",
  as: "disposable_method_details",
});

WasteManifest.belongsTo(ContractorRegistration, {
  foreignKey: "contractor",
  as: "contractor_details",
});

WasteManifest.belongsTo(Organization, {
  foreignKey: "organization",
  as: "organization_details",
});

WasteManifest.belongsTo(Department, {
  foreignKey: "department",
  as: "department_details",
});

WasteManifest.belongsTo(User, {
  foreignKey: "created_by",
  as: "created_by_details",
});

// WasteType.hasMany(WasteManifest, {
//   foreignKey: "waste_type",
//   as: "waste_manifests",
// });

// WasteDisposalMethod.hasMany(WasteManifest, {
//   foreignKey: "disposable_method",
//   as: "waste_manifests",
// });

// // ContractorRegistration.hasMany(WasteManifest, {
// //   foreignKey: "contractor",
// //   as: "waste_manifests",
// // });

// // Organization.hasMany(WasteManifest, {
// //   foreignKey: "organization",
// //   as: "waste_manifests",
// // });

// // Department.hasMany(WasteManifest, {
// //   foreignKey: "department",
// //   as: "waste_manifests",
// // });

// // User.hasMany(WasteManifest, {
// //   foreignKey: "created_by",
// //   as: "waste_manifests",
// // });

// WasteType;
// WasteDisposalMethod;
// ContractorRegistration;
// Organization;
// Department;
// User;

// console.log(await WasteManifest.sync({ alter: true }));

export default WasteManifest;
