import { DataTypes } from "sequelize";
import sequelize from "./sequelize.js"; // Adjust the import path as necessary
import User from "./UserSchema.js";
import SOP from "./SOPSchema.js";

const SOPComment = sequelize.define(
  "SOPComment",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    sop_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: SOP,
        key: "id",
      },
      onUpdate: "CASCADE",
      onDelete: "SET NULL",
    },
    comments: {
      type: DataTypes.TEXT("long"),
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("approved", "rejected"),
      allowNull: true,
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true,
      defaultValue: sequelize.literal("CURRENT_TIMESTAMP"),
    },
    created_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: User,
        key: "id",
      },
      //onUpdate: "CASCADE",
      //onDelete: "SET NULL",
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
  },
  {
    tableName: "sop_comments",
    timestamps: false,

    charset: "utf8mb4",
    collate: "utf8mb4_general_ci",
  }
);

SOPComment.belongsTo(SOP, {
  foreignKey: "sop_id",
  as: "sop",
});

SOPComment.belongsTo(User, {
  foreignKey: "created_by",
  as: "CreatedByUser",
});

SOPComment.belongsTo(User, {
  foreignKey: "updated_by",
  as: "UpdatedByUser",
});

// console.log(await SOPComment.sync({ alter: true }));

export default SOPComment;
