import fs from "fs";
import { fileURLToPath } from "url";
import { dirname } from "path";
import path from "path";

const __filename = fileURLToPath(import.meta.url);
const __dirname = dirname(__filename);

// Utility function to create controller file
export const createControllerFile = (controllerName) => {
  const controllerDir = path.join(__dirname, "..", "controller");
  const filePath = path.join(controllerDir, `${controllerName}Controller.js`);

  // Check if the file already exists
  if (fs.existsSync(filePath)) {
    console.log(
      `Controller file ${filePath} already exists. Skipping creation.`
    );
    return;
  }

  // Define the content of the controller file
  const fileContent = `
  import {controllerWrapper , sendResponse} from "../helper/wrapper.js";
  import path from "path";
  import { fileURLToPath } from "url";
  import db from "../db-config.js";
  import { FetchedResultDecodeData,, countQueryCondition, createQueryBuilder, deleteRecord, encodeData, getParentLevel, makeJoins, makeNameQuery, searchConditionRecord, sendErrorResponse, updateQueryBuilder, uploadFile, validateRequest, whereCondition } from "../helper/general.js";
  import { createUpdate${capitalize(
    controllerName
  )}ValidationSchema } from "../validationsRecord/validationSchema.js";
  const __filename = fileURLToPath(import.meta.url);
  const __dirname = path.dirname(__filename);
  /**Function to create and update ${controllerName}*/
  export const createUpdate${capitalize(controllerName)} = async (req, res) => {
      const profile = req.files && req.files.profile;
      /**Check if that these fields is missing then show error that this field is missing */
      await validateRequest(createUpdate${capitalize(
        controllerName
      )}ValidationSchema, req, res);
      /**Check that if description is coming then encode it */
      if (req.body.description) req.body.description = await encodeData(req.body.description);
      req.body.parent_id = req.body.parent_id ? req.body.parent_id : null;
      const status = req.body.id ? "Updated" : "Created";
      req.body[req.body.id ? "updated_by" : "created_by"] = req.user.sessionid;
      const { query, values } = req.body.id ? updateQueryBuilder(${controllerName}StructureSchema, req.body) : createQueryBuilder(${controllerName}StructureSchema, req.body);
      await db.query(query, values);
      return sendResponse(res, 200, \`Record \${status} successfully\`)
};
/**Function to get post ${capitalize(controllerName)} */
export const getUsers${capitalize(controllerName)} = async (req, res) => {
      const request = { "table": "${tableNameMaker(
        controllerName
      )}", "page": req.query.page, "all": req.query.all, "pageSize": req.query.pageSize, "filter": req.query.filter, "id": req.params.id }
      const condition = await whereCondition(request);
      /** If value come with any search condition then search that word */
      const searchTableName = ['${tableNameMaker(
        controllerName
      )}.name', '${tableNameMaker(
    controllerName
  )}.description', 'createdUser.name' , department.name , organization.name ];
      let searchCondition = await searchConditionRecord(req.query.search, searchTableName)
      /**Make Joins according to tables */
      const nameDetailsArray = [
          { table: "createdUser", name: 'created_by', fields: ['name', 'profile', 'surname'] }
      ]
      const nameDetailsQuery = await makeNameQuery(nameDetailsArray);
      /**Make joins record query */
      const joins = [
          {
              type: "left",
              targetTable: "users as createdUser",
              onCondition: "createdUser.id = ${tableNameMaker(
                controllerName
              )}.created_by",
          },
          {
              type: "left",
              targetTable: "department",
              onCondition: "department.id = ${tableNameMaker(
                controllerName
              )}.department",
          },
          {
              type: "left",
              targetTable: "organization",
              onCondition: "organization.id = ${tableNameMaker(
                controllerName
              )}.organization",
          }
      ];
      const joinsRecord = await makeJoins(joins);
      /**Record of all plugin users */
      const ${controllerName}DataFetchQuery = \`SELECT \${nameDetailsQuery},${tableNameMaker(
    controllerName
  )}.* FROM ${tableNameMaker(
    controllerName
  )} \${joinsRecord} where ${tableNameMaker(
    controllerName
  )}.deleted = 0 \${searchCondition} \${condition}\`;
      let [${controllerName}DataFetch] = await db.query(${controllerName}DataFetchQuery);
      ${controllerName}DataFetch = await decodeAndParseFields(${controllerName}DataFetch)
      const totalRecord = await countQueryCondition(${controllerName}DataFetchQuery);
      return sendResponse(res, 200 ,${controllerName}DataFetch )
};
/**Function to delete ${capitalize(controllerName)} record */
export const delete${capitalize(controllerName)} = async (req, res) => {
      const [deleteData] = await deleteRecord("${controllerName}", req.params.id);
      if (deleteData.status == false) {
          return sendErrorResponse(res, 404, "This ${controllerName} is using somewhere so it can't be deleted.");
      } else {
          return sendResponse(res, 200, \`Record deleted successfully\`);
      }
};`;

  // Create the controllers directory if it doesn't exist
  if (!fs.existsSync(controllerDir)) {
    fs.mkdirSync(controllerDir, { recursive: true });
  }

  // Write the content to the file
  fs.writeFileSync(filePath, fileContent.trim());
  console.log(`Controller file created at ${filePath}`);
};

// Utility function to create routes file
export const createRoutesFile = (entityName) => {
  const routesDir = path.join(__dirname, "..", "routes"); // Updated path to go one level up
  const filePath = path.join(routesDir, `${entityName}Routes.js`);

  // Check if the file already exists
  if (fs.existsSync(filePath)) {
    console.log(`Routes file ${filePath} already exists. Skipping creation.`);
    return;
  }

  // Define the content of the routes file
  const fileContent = `
                      // Import necessary modules
                      import { Router } from "express";
                      import { verifyToken } from "../helper/tokenVerify.js";
                      import { createUpdate${capitalize(
                        controllerName
                      )}ValidationSchema } from "../validationsRecord/validationSchema.js";
                      import { sideBarPermissionCheck } from "../helper/checkPermission.js";
                      import { createUpdated${capitalize(
                        entityName
                      )}, delete${capitalize(entityName)}, viewAll${capitalize(
    entityName
  )} } from "../controller/${entityName}Controller.js";

                      /**
                       * @swagger
                       * tags:
                       *   name: ${capitalize(entityName)}
                       *   description: API operations for managing ${entityName}
                       */
                      const ${entityName}Routes = Router();

                      /**
                       * @swagger
                       * /api/${entityName}/create-update-${entityName}:
                       *   post:
                       *     summary: Create or update a ${entityName}
                       *     tags: [${capitalize(entityName)}]
                       *     requestBody:
                       *       required: true
                       *       content:
                       *         application/json:
                       *           example: { id: "id", title: "title", jd: "jd" }
                       */
                      ${entityName}Routes.post("/create-update-${entityName}", verifyToken,(req, res, next) => { sideBarPermissionCheck(req.body.id ? 'edit' : 'create', 13)(req, res, next); },  validateRequest(createUpdate${capitalize(
    controllerName
  )}ValidationSchema) , createUpdated${capitalize(entityName)});

                      /**
                       * @swagger
                       * /api/${entityName}/get-${entityName}:
                       *   get:
                       *     summary: Get all list of ${capitalize(entityName)}
                       *     tags: [${capitalize(entityName)}]
                       */
                      ${entityName}Routes.get("/get-${entityName}", verifyToken, sideBarPermissionCheck('view', 13), viewAll${capitalize(
    entityName
  )});

                      /**
                       * @swagger
                       * /api/${entityName}/get-${entityName}/{id}:
                       *   get:
                       *     summary: Get a specific record of ${capitalize(
                         entityName
                       )}
                       *     tags: [${capitalize(entityName)}]
                       */
                      ${entityName}Routes.get("/get-${entityName}/:id", verifyToken, sideBarPermissionCheck('view', 13), viewAll${capitalize(
    entityName
  )});

                      /**
                       * @swagger
                       * /api/${entityName}/delete-${entityName}/{id}:
                       *   delete:
                       *     summary: Delete a specific record of ${capitalize(
                         entityName
                       )}
                       *     tags: [${capitalize(entityName)}]
                       */
                      ${entityName}Routes.delete("/delete-${entityName}/:id", verifyToken, sideBarPermissionCheck('delete', 13), delete${capitalize(
    entityName
  )});

                      export default ${entityName}Routes;`;

  // Create the routes directory if it doesn't exist
  if (!fs.existsSync(routesDir)) {
    fs.mkdirSync(routesDir, { recursive: true });
  }

  // Write the content to the file
  fs.writeFileSync(filePath, fileContent.trim());
  console.log(`Routes file created at ${filePath}`);
};

// Function to capitalize the first letter of a string
const capitalize = (str) => {
  return str.charAt(0).toUpperCase() + str.slice(1);
};

/**Function to Generate table Name Using Controller Name */
const tableNameMaker = (str) => {
  let result = "";
  for (let i = 0; i < str.length; i++) {
    const char = str.charAt(i);
    if (char === char.toUpperCase()) {
      result += "_" + char.toLowerCase();
    } else {
      result += char;
    }
  }
  if (result.charAt(0) === "_") {
    result = result.slice(1);
  }
  return result;
};

createControllerFile("purposeOfTraining");
createRoutesFile("purposeOfTraining");
