import db from "../db-config.js";
import { sendResponse } from "../helper/wrapper.js";
import {
    searchConditionRecord,
    makeJoins,
    whereCondition,
    countQueryCondition,
} from "../helper/general.js";
import ActivityLog from "../sequelize/ActivityLogSchema.js"; // for sync purpose only not to be removed
import moment from "moment";
export const viewActivityLog = async (req, res) => {
    const { id } = req.params;
    const { start_date, end_date } = req.query;
    const condition = await whereCondition({
        table: "activity_log",
        page: req.query.page,
        all: req.query.all,
        pageSize: req.query.pageSize,
        filter: req.query.filter,
        id,
        user: req.user,
        grouped: req.query.grouped,
    });

    const searchFields = [
        "activity_log.status",
        "activity_log.module",
        "users.name",
    ];
    let searchCondition = await searchConditionRecord(
        req.query.search,
        searchFields
    );
    const joins = [
        {
            type: "left",
            targetTable: "users",
            onCondition: "users.id = activity_log.created_by",
        },
    ];
    const joinsRecord = await makeJoins(joins);
    let dateCondition = '';
    if (start_date && end_date) {
        if (moment(start_date).isValid() && moment(end_date).isValid()) {
            const start = moment(start_date).startOf('day').format('YYYY-MM-DD HH:mm:ss');
            const end = moment(end_date).endOf('day').format('YYYY-MM-DD HH:mm:ss');
            dateCondition = `AND activity_log.created_at BETWEEN '${start}' AND '${end}'`;
        }
        else dateCondition = '';
    }

    const fetchQuery = `SELECT activity_log.*, users.name AS created_by FROM activity_log ${joinsRecord} WHERE activity_log.deleted = 0 ${searchCondition} ${dateCondition} ${condition}`;
    let [records] = await db.query(fetchQuery);

    const totalRecord = await countQueryCondition(fetchQuery);
    return sendResponse(res, 200, records, totalRecord);
};