import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeSingle_statement,
  insertActivityLog,
  makeJoins,
  whereCondition,
  searchConditionRecord,
  settingsUpdater,
  getRecord,
  getListingData,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  uniqueIdGenerator,
} from "../helper/general.js";
import AppointmentType from "../sequelize/AppointmentTypeSchema.js";
import { sendResponse } from "../helper/wrapper.js";
import { updateQueryBuilder } from "../helper/queryBuilder.js";

/**Function to create and update License  */
export const createUpdatedAppointmentType = async (req, res) => {
  const { id, name, assignment, designated, applicable, organization } =
    req.body;

  const encodedAssignment = await encodeSingle_statement(assignment);
  const encodedDesignation = await encodeSingle_statement(designated);
  const encodedApplicable = await encodeSingle_statement(applicable);

  req.body.assignment = encodedAssignment;
  req.body.designated = encodedDesignation;
  req.body.applicable = encodedApplicable;
 
  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "AppointmentType",
      "appointment_type",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization =
      organization.length > 0 ? organization : result.organizationIds;
  }
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  /**If id comes in body then it will update the query */
  const [checkNameWithOrganization] = await getRecord(
    "appointment_type",
    "name",
    name
  );
  if (checkNameWithOrganization) {
    if (id && checkNameWithOrganization.id != id) {
      return sendResponse(res, 400, "Appointment Type name already exist");
    } else if (!id) {
      return sendResponse(res, 400, "Appointment Type name already exist");
    }
  }
  if (id) {
    /**Check that this organization have that particular name or not*/
    if (organization.length === 0) {
      return sendResponse(
        res,
        400,
        "Please Select at least one business Structure"
      );
    }

    /**update query */
    const { query, values } = updateQueryBuilder(AppointmentType, req.body);
    await db.query(query, values);
    /**Update record for activity log */
    await insertActivityLog(req.user.sessionid, "update", "AppointmentType", id);
    return sendResponse(res, 200, "Record updated successfully");
  } else {
    const { query, values } = createQueryBuilder(AppointmentType, req.body);
    const result = await db.query(query, values);
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "create",
      "AppointmentType",
      result.insertId
    );
    return sendResponse(res, 200, "Record created successfully");
  }








  // /**If id comes in body then it will update the query */
  // if (id) {
  //   req.body.updated_by = req.user.sessionid;
  //   if (organization.length === 0) {
  //     return sendResponse(
  //       res,
  //       400,
  //       false,
  //       "Please Select at least one organization"
  //     );
  //   }
  //   const result = await settingsUpdater(
  //     AppointmentType,
  //     organization,
  //     req.body,
  //     req.user
  //   );

  //   if (!result) {
  //     return sendResponse(res, 404, "Record data found");
  //   }

  //   return sendResponse(res, 200, "Record Updated Successfully");
  // } else {
  //   const insertPromises = organization.map(async (element) => {
  //     /** Check if this organization already has the particular name */
  //     const [checkNameWithOrganization] = await db.query(
  //       `SELECT name FROM appointment_type WHERE name = ? AND deleted = '0' AND organization = ?`,
  //       [name, element]
  //     );

  //     /** If record not found for that name with particular organization, insert the record */
  //     if (checkNameWithOrganization.length === 0) {
  //       /** Insert License details */
  //       req.body.created_by = req.user.sessionid;
  //       req.body.organization = element;
  //       const { query, values } = createQueryBuilder(AppointmentType, {
  //         ...req.body,
  //         organization: element,
  //       });

  //       await db.query(query, values);

  //       /** Insert record for activity log */
  //       await insertActivityLog(
  //         req.user.sessionid,
  //         "create",
  //         "License",
  //         `This user created a new other Skills named ${name} for organization ${element}`
  //       );
  //     }
  //   });

  //   await Promise.all(insertPromises);

  //   return sendResponse(res, 200, "Record created successfully");
  // }
};

/**Function to view all License */
export const viewAllAppointmentType = async (req, res) => {
 
  let { organizationCondition, condition } = await getFilterConditions(
    req,
    db,
    "appointment_type"
  );
  /** If value come with any search condition then search that word */
  const searchTableName = [
    "appointment_type.name",
    "appointment_type.assignment",
    "appointment_type.designated",
    "appointment_type.applicable",
    "createdUser.name",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(
    req.query.search,
    searchTableName
  );
  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users as createdUser",
      onCondition: "createdUser.id = appointment_type.created_by",
    },
  ];
  const joinsRecord = await makeJoins(joins);
  /**Record of all Skill */
  let appointmentTypeQuery = `SELECT 
  appointment_type.*, 
  appointment_type.organization AS organizations, 
  createdUser.name AS created_by, 
  createdUser.surname AS created_by_surname, 
  createdUser.id AS created_by_id, 
  createdUser.profile AS created_by_profile
FROM appointment_type
${joinsRecord} 
WHERE appointment_type.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;

  // console.log(skillQuery, "skillQuery");
  let [appointmentType] = await db.query(appointmentTypeQuery);
  appointmentType = await getListingData(appointmentType);
  /**Count all organization */
  const totalRecord = await countQueryCondition(appointmentTypeQuery);
  return sendResponse(res, 200, appointmentType, totalRecord);

 
 
 
 
 
  // const { id } = req.params;
  // const condition = await whereCondition({
  //   table: "appointment_type",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   grouped: req.query.grouped,
  //   user: req.user,
  // });

  // const searchTableName = [
  //   "appointment_type.name",
  //   "appointment_type.assignment",
  //   "appointment_type.designated",
  //   "appointment_type.applicable",
  //   "createdUser.name",
  //   "organization.name",
  // ];
  // /** If value come with any search condition then search that word */
  // let searchCondition = await searchConditionRecord(
  //   req.query.search,
  //   searchTableName
  // );

  // /**Make Joins according to tables */
  // const joins = [
  //   {
  //     type: "left",
  //     targetTable: "users as createdUser",
  //     onCondition: "createdUser.id = appointment_type.created_by",
  //   },
  //   {
  //     type: "left",
  //     targetTable: "organization",
  //     onCondition: "organization.id = appointment_type.organization",
  //   },
  // ];
  // const joinsRecord = await makeJoins(joins);

  // /**Record of all alert */
  // const appointmentTypeDataFetchQuery = `SELECT appointment_type.*, createdUser.name as created_by , createdUser.surname as created_by_surname , createdUser.id as created_by_id , createdUser.profile as created_by_profile , organization.name as organization_name
  //   FROM appointment_type  
  //   ${joinsRecord} 
  //   where appointment_type.deleted = 0 ${searchCondition} ${condition}`;

  // const [appointmentTypeDataFetch] = await db.query(
  //   appointmentTypeDataFetchQuery
  // );

  // for (const appointmentType of appointmentTypeDataFetch) {
  //   appointmentType.applicable = await decodeSingle_statement(
  //     appointmentType.applicable
  //   );
  //   appointmentType.assignment = await decodeSingle_statement(
  //     appointmentType.assignment
  //   );
  //   appointmentType.designated = await decodeSingle_statement(
  //     appointmentType.designated
  //   );
  //   if (req.query.grouped === "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM appointment_type WHERE deleted = 0 AND name = ?`,
  //       [appointmentType.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     appointmentType.organizations = arr;
  //   }
  // }

  // /**Count all license */
  // const totalRecord = await countQueryCondition(appointmentTypeDataFetchQuery);

  // return sendResponse(res, 200, appointmentTypeDataFetch, totalRecord);
};

/**Function to delete a specific License */
export const deleteAppointmentType = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("appointment_type", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(
      req.user.sessionid,
      "delete",
      "Appointment Type",
      id
    );
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
