import db from "../db-config.js";
import {
  countQueryCondition,
  createQueryBuilder,
  decodeSingle_statement,
  deleteSettingRecord,
  encodeAndStringifyFields,
  encodeSingle_statement,
  getFilterConditions,
  getFirstCreatedAndAllOrganizationIds,
  getListingData,
  insertActivityLog,
  makeJoins,
  searchConditionRecord,
  settingsUpdater,
  uniqueIdGenerator,
  updateQueryBuilder,
  whereCondition,
} from "../helper/general.js";
import AccessorMethod from "../sequelize/AssessorMethodSchema.js";
import { sendResponse } from "../helper/wrapper.js";

/**Function to create new Accessor Method for employee  */
export const createUpdateAccessorMethod = async (req, res) => {
  const { id, organization } = req.body;

  if (id && organization.length === 0) {
    return sendResponse(res, 404, "Please Select at least one business Structure");
  }

  if (!id) {
    const result = await getFirstCreatedAndAllOrganizationIds();

    if (!result.firstOrgId) {
      return sendResponse(res, 404, "No organization found.");
    }
    const unique_id = await uniqueIdGenerator(
      result.firstOrgId,
      req.body?.department || null,
      "AccessorMethod",
      "assessor_method",
      "unique_id",
      "unique_id"
    );
    req.body.unique_id = unique_id;
    req.body.organization = organization.length > 0 ? organization : result.organizationIds;
  }

  let status = id ? "Updated" : "Created";
  req.body[id ? "updated_by" : "created_by"] = req.user.sessionid;
  req.body = await encodeAndStringifyFields(req.body);
  const { query, values } = id
    ? updateQueryBuilder(AccessorMethod, req.body)
    : createQueryBuilder(AccessorMethod, req.body);
  const [result] = await db.query(query, values);
  await insertActivityLog(req.user.sessionid, status, "AccessorMethod", id ? id : result.insertId);
  return sendResponse(res, 200, `Record ${status} Successfully`);
};
// export const createUpdateAccessorMethod = async (req, res) => {
//   const { id, name, description, organization } = req.body;
//   const encodedDescription = await encodeSingle_statement(description);

//   /**If id comes in body then it will update the query */
//   if (id) {
//     if (organization.length === 0) {
//       return sendResponse(
//         res,
//         200,
//         "Please select at least one business structure"
//       );
//     }
//     const result = await settingsUpdater(
//       AccessorMethod,
//       organization,
//       req.body,
//       req.user
//     );
//     if (!result) {
//       return sendResponse(res, 404, "No data found");
//     }

//     /**Insert record for activity log */
//     await insertActivityLog(
//       req.user.sessionid,
//       "update",
//       "insurance Policy Impact",
//       `This user Update insurance Policy Impact which id is ${id}`
//     );

//     return sendResponse(res, 200, "Record updated successfully");
//   } else {
//     /** Insert new record */
//     const insertPromises = organization.map(async (element) => {
//       // Check if the category type already exists for the organization
//       const [checkNameWithOrganization] = await db.query(
//         `SELECT name FROM assessor_method WHERE name = ? AND deleted = "0" AND organization = ?`,
//         [name, element]
//       );

//       // If record not found for that name with particular organization, insert the record
//       if (checkNameWithOrganization.length === 0) {
//           const unique_id = await uniqueIdGenerator(
//             element,
//             req.body?.department || null,
//             "AccessorMethod",
//             "assessor_method",
//             "unique_id",
//             "unique_id"
//           );

//         // Insert insurance Policy Impact details
//         const insertAccessorMethodQuery = `INSERT INTO assessor_method(name, description, created_by, organization,unique_id) VALUES (?,?, ?, ?, ?)`;
//         await db.query(insertAccessorMethodQuery, [
//           name,
//           encodedDescription,
//           req.user.sessionid,
//           element,
//           unique_id
//         ]);

//         // Insert record for activity log
//         await insertActivityLog(
//           req.user.sessionid,
//           "create",
//           "insurance Policy Impact",
//           `This user created a new category '${name}' for this organization ${element}`
//         );
//       }
//     });

//     await Promise.all(insertPromises);

//     return sendResponse(res, 200, "Record created successfully");
//   }
// };

/**Function to view all and single Accessor Method */
export const viewAccessorMethod = async (req, res) => {
  let { organizationCondition, condition } = await getFilterConditions(req, db, "assessor_method");

  // const { id } = req.params;

  // const condition = await whereCondition({
  //   table: "assessor_method",
  //   page: req.query.page,
  //   all: req.query.all,
  //   pageSize: req.query.pageSize,
  //   filter: req.query.filter,
  //   id,
  //   user: req.user,
  //   grouped: req.query.grouped,
  // });

  const searchTableName = [
    "assessor_method.name",
    "assessor_method.description",
    "CONCAT(users.name , ' ' , users.surname)",
  ];
  /** If value come with any search condition then search that word */
  let searchCondition = await searchConditionRecord(req.query.search, searchTableName);

  /**Make Joins according to tables */
  const joins = [
    {
      type: "left",
      targetTable: "users",
      onCondition: "users.id = assessor_method.created_by",
    },
    // {
    //   type: "left",
    //   targetTable: "organization",
    //   onCondition: "organization.id = assessor_method.organization",
    // },
    {
      type: "left",
      targetTable: "department",
      onCondition: "department.id = assessor_method.department",
    },
  ];
  const joinsRecord = await makeJoins(joins);

  const accessorMethodQuery = `SELECT assessor_method.*,users.id AS created_by_id, users.name AS created_by, assessor_method.organization AS organizations , users.surname as created_by_surname , users.profile as created_by_profile , department.name as department_name FROM assessor_method ${joinsRecord} where assessor_method.deleted = 0 ${searchCondition} ${organizationCondition} ${condition}`;
  // return console.log(
  //   accessorMethodQuery,
  //   "accessorMethodQuery"
  // );
  let [accessorMethodRecord] = await db.query(accessorMethodQuery);

  accessorMethodRecord = await getListingData(accessorMethodRecord);
  // for (const item of accessorMethodRecord) {
  //   item.description = await decodeSingle_statement(item.description);
  //   if (req.query.grouped == "true") {
  //     const [organizations] = await db.query(
  //       `SELECT organization FROM assessor_method WHERE deleted = 0 AND name = ?`,
  //       [item.name]
  //     );
  //     const arr = organizations.map((item) => item.organization);
  //     item.organizations = arr;
  //   }
  // }

  /**Count all organization */
  const totalRecord = await countQueryCondition(accessorMethodQuery);

  return sendResponse(res, 200, accessorMethodRecord, totalRecord);
};

/**Function to delete a specific Accessor Method */
export const deleteAccessorMethod = async (req, res) => {
  const { id } = req.params;
  const deleteRecordQuery = await deleteSettingRecord("assessor_method", id);
  if (deleteRecordQuery) {
    /**Insert record for activity log */
    await insertActivityLog(req.user.sessionid, "delete", "Accessor Method", id);
    return sendResponse(res, 200, "Record deleted successfully");
  }
};
